
%add_findpackage_path %_K4bindir
%add_findreq_skiplist %_K4apps/lokalize/scripts/*.py
%add_findreq_skiplist %_K4bindir/kdedoc
%add_findreq_skiplist %_K4bindir/package_crystalsvg

%def_disable kio_svn

%define rname kdesdk
Name: kde4sdk
%define major 15
%define minor 12
%define bugfix 2
Version: %major.%minor.%bugfix
Release: alt1

Group: Graphical desktop/KDE
Summary: K Desktop Environment - Software Development Kit
License: GPL
Url: ftp://ftp.kde.org/pub/kde/stable/%version/src/
Packager: Sergey V Turchin <zerg at altlinux dot org>

Requires: %name-core = %version-%release
Requires: %name-lokalize = %version-%release
Requires: %name-kapptemplate = %version-%release
Requires: %name-kuiviewer = %version-%release
Requires: %name-scripts = %version-%release
#Requires: %name-kbugbuster = %version-%release
Requires: %name-strigi-analyzer = %version-%release
Requires: %name-po2xml = %version-%release
Requires: %name-umbrello = %version-%release
Requires: %name-cervisia = %version-%release
Requires: %name-kompare = %version-%release
Requires: %name-kmtrace = %version-%release
Requires: %name-kcachegrind = %version-%release
Requires: %name-dolphin = %version-%release
Requires: %name-okteta = %version-%release
Requires: %name-thumbnailers = %version-%release


Source: ftp://ftp.kde.org/pub/kde/stable/%version/src/%rname-%version.tar
Patch1: kdesdk-4.0.2-alt-find-libsvn.patch

BuildRequires(pre): kde4libs-devel
%if_enabled kio_svn
BuildRequires: libsubversion-devel
%endif
BuildRequires: perl-XML-DOM perl-Switch libldap-devel libltdl-devel gcc-c++
BuildRequires: rpm-build-python python-modules-encodings
BuildRequires: libiberty-devel libjpeg-devel libxslt-devel bzlib-devel
BuildRequires: gettext-tools
BuildRequires: boost-devel libhunspell-devel desktop-file-utils perl-Pod-Parser
BuildRequires: kde4libs-devel kde4base-devel
BuildRequires: kde4pimlibs-devel
BuildRequires: kde4base-workspace-devel libkomparediff2-devel

%description
Software Development Kit for the K Desktop Environment.

%package common
Summary: Common empty package for %rname
Group: System/Configuration/Other
BuildArch: noarch
Requires: kde-common >= %major.%minor
Conflicts: kdesdk-common <= 3.5.12-alt1
%description common
Common empty package for %rname

%package core
Summary: Core files needed for %rname
Group: Graphical desktop/KDE
Requires: %name-common = %version-%release
%description core
Core files needed for %rname

%package okteta
Summary: Byte level data editor
Group: Development/Tools
Requires: %name-common = %version-%release
Provides: kde4utils-okteta = %version-%release
Obsoletes: kde4utils-okteta < %version-%release
%description okteta
Viewing and editing of data on the byte level

%package -n libokteta1core4
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libokteta1core4
KDE 4 library

%package -n libokteta1gui4
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libokteta1gui4
KDE 4 library

%package -n libkasten2okteta1controllers4
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libkasten2okteta1controllers4
KDE 4 library

%package -n libkasten2okteta1core4
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libkasten2okteta1core4
KDE 4 library

%package -n libkasten2okteta1gui4
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libkasten2okteta1gui4
KDE 4 library

%package lokalize
Group: Development/Tools
Summary: Computer-aided translation system
Requires: %name-core = %version-%release
Provides: %name-localize = %version-%release
%description lokalize
Computer-aided translation system

%package kapptemplate
Summary: Template for KDE Application Development
Group: Development/KDE and QT
Requires: %name-core = %version-%release
%description kapptemplate
KAppTemplate is a set of modular shell scripts that will create a
framework for any number of KDE application types. At it's base
level, it handles creation of things like the automake/autoconf
framework, lsm files, RPM spec files, and po files. Then, there
are individual modules that allow you to create a skeleton KDE
application, a KPart application, a KPart plugin, or even convert
existing source code to the KDE framework.

%package kuiviewer
Summary: UI Files Viewer
Group: Development/KDE and QT
Provides: kuiviewer4
Requires: %name-core = %version-%release
%description kuiviewer
Displays Qt Designer UI files

%package scripts
Summary: Script From kdesdk
Group: Development/KDE and QT
BuildArch: noarch
Requires: %name-core = %version-%release
%description scripts
This package contains the scripts for KDE development which are
contained in the %rname module.

%package kbugbuster
Summary: kbugbuster
Group: Development/KDE and QT
Provides: kbugbuster4
Requires: %name-core = %version-%release
%description kbugbuster
Kbugbuster

%package strigi-analyzer
Summary: Strigi Analyzer
Group: Development/KDE and QT
Requires: %name-common = %version-%release
%description strigi-analyzer
Strigi analyzer

%package po2xml
Summary: Xml2po and vice versa converters
Group: Development/KDE and QT
Requires: %name-common = %version-%release
%description po2xml
An xml2po and vice versa converters.

%package devel
Summary: Header files for %rname
Group: Development/KDE and QT
Requires: %name-common = %version-%release
Requires: kde4-kate-devel
%description devel
This package includes the header files you will need to compile
applications for %rname.

%package umbrello
Summary: UML Modeller
Group: Development/Tools
Requires: %name-core = %version-%release
%description umbrello
Umbrello UML Modeller is a UML diagramming tool for KDE.

%package cervisia
Summary: CVS client part
Group: Development/Tools
Requires: %name-common = %version-%release
%description cervisia
CVS client part.

%package kompare
Summary: KDE diff graphic tool
Group: Development/Tools
Requires: %name-core = %version-%release
%description kompare
kompare is a KDE diff graphic tool

%package kmtrace
Summary: Memory Allocation Debugging Tool
Group: Development/Tools
Requires: %name-core = %version-%release
%description kmtrace
Memory Allocation Debugging Tool

%package kcachegrind
Summary: KCachegrind
Group: Development/Tools
Requires: %name-core = %version-%release
%ifarch %ix86
Requires: valgrind
%endif
%description kcachegrind
KCachegrind is a visualisation tool for the profiling data generated by
Cachegrind and Calltree (they profile data file format is upwards compatible).
Calltree extends Cachegrind, which is part of Valgrind.

%package dolphin
Summary: Dolphin plugins for development
Group: Development/Tools
Requires: kde4base-dolphin
%description dolphin
Dolphin plugins for development

%package thumbnailers
Summary: Thumbnailers for various development files
Group: Development/Tools
Requires: kde4base-dolphin
%description thumbnailers
Thumbnailers for various development files

%package libs
Summary: %name core libraries
Group: System/Libraries
#Requires: %name-common = %version-%release
%description libs
%name core libraries

%package -n libkasten2controllers4
Summary: %name library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libkasten2controllers4
%name library.

%package -n libkasten2core4
Summary: %name library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libkasten2core4
%name library.

%package -n libkasten2gui4
Summary: %name library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libkasten2gui4
%name library.

%package -n libkompareinterface4
Summary: %name library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libkompareinterface4
%name library.

%package -n libktrace4
Summary: %name library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libktrace4
%name library.


%prep
%setup -q -n %rname-%version
#%patch1 -p1


%build
export PATH=%_kde4_bindir:$PATH
ls -d1 * | \
while read d
do
    [ -f "$d"/CMakeLists.txt ] || continue
    pushd $d
    %K4build \
	-DKDE4_BUILD_TESTS=OFF \
	-DBUILD_KF5=OFF \
	-DHUNSPELL_INCLUDE_DIR=%_includedir \
	-DHUNSPELL_LIBRARIES=%_libdir/libhunspell.so
    popd
done

%install
export PATH=%_kde4_bindir:$PATH

ls -d1 * | \
while read d
do
    [ -f "$d"/CMakeLists.txt ] || continue
    pushd $d
    %K4install
    popd
done

# fix scripts for strong /usr/lib/rpm/find-requires
pushd %buildroot/%_K4bindir
for f in `(file ./* | grep bash; file ./* | grep shell) | awk -F: '{print $1}' | xargs grep -l ^=head`
do
    mv "$f" "$f.tmp"
    awk 'BEGIN{found=0;} /^=head/ {if (found==0){print "cat <<\\__EOF__";found=1;};} {print} END{if (found!=0) print "__EOF__";}' <"$f.tmp" >"$f"
    rm -f "$f.tmp"
    chmod a+x $f
done
popd

# resilve conflict with subversion-tools
mv %buildroot/%_K4bindir/svn-clean %buildroot/%_K4bindir/svnclean




%files
%files libs
%files common
%files core
%_K4bindir/cvsaskpass
%_K4bindir/cvsservice
%_K4bindir/kstartperf
%_K4bindir/kpartloader
%_K4libdir/libkdeinit4_cvsaskpass.so
%_K4libdir/libkdeinit4_cvsservice.so
%_K4lib/kio_perldoc.so
%_K4lib/kstartperf.so
%_K4apps/kio_perldoc/
%_K4apps/kpartloader/
%_K4srv/perldoc.protocol
#%_K4iconsdir/locolor/*/actions/*.*
%_K4iconsdir/hicolor/*/actions/*.*
%_K4iconsdir/hicolor/*/mimetypes/application-x-uml.*

%files thumbnailers
%_K4lib/*thumbnail.so
%_K4srv/*thumbnail.desktop
%_K4cfg/pocreatorsettings.kcfg

%files okteta
%_K4bindir/okteta
%_K4bindir/struct2osd.sh
%_K4lib/libkbytearrayedit.so
%_K4lib/oktetapart.so
%_K4xdg_apps/okteta.desktop
%_K4apps/okteta/
%_K4apps/oktetapart/
%_K4iconsdir/hicolor/*/apps/okteta.*
%_K4srv/kbytearrayedit.desktop
%_K4srv/oktetapart.desktop
%_K4cfg/structviewpreferences.kcfg
%_K4conf/okteta-structures.knsrc
%_K4xdg_mime/okteta.xml
%_K4doc/*/okteta

%files -n libkasten2okteta1core4
%_K4libdir/libkasten2okteta1core.so.*
%files -n libkasten2okteta1gui4
%_K4libdir/libkasten2okteta1gui.so.*
%files -n libkasten2okteta1controllers4
%_K4libdir/libkasten2okteta1controllers.so.*
%files -n libkasten2controllers4
%_K4libdir/libkasten2controllers.so.*
%files -n libokteta1core4
%_K4libdir/libokteta1core.so.*
%files -n libokteta1gui4
%_K4libdir/libokteta1gui.so.*
%files -n libkasten2core4
%_K4libdir/libkasten2core.so.*
%files -n libkasten2gui4
%_K4libdir/libkasten2gui.so.*

%files dolphin
%_K4lib/fileviewdropboxplugin.so
%_K4lib/fileviewgitplugin.so
%_K4lib/fileviewsvnplugin.so
%_K4lib/fileviewbazaarplugin.so
%_K4lib/fileviewhgplugin.so
%_K4cfg/fileviewsvnpluginsettings.kcfg
%_K4cfg/fileviewgitpluginsettings.kcfg
%_K4cfg/fileviewhgpluginsettings.kcfg
%_K4srv/fileviewdropboxplugin.desktop
%_K4srv/fileviewgitplugin.desktop
%_K4srv/fileviewsvnplugin.desktop
%_K4srv/fileviewbazaarplugin.desktop
%_K4srv/fileviewhgplugin.desktop

%files lokalize
%_K4bindir/lokalize
%_K4xdg_apps/lokalize.desktop
%_K4apps/lokalize/
%_K4cfg/lokalize.kcfg
%_datadir/strigi/fieldproperties/strigi_translation.fieldproperties
%_K4iconsdir/*/*/apps/lokalize.*
%_K4doc/*/lokalize

%files kapptemplate
%_K4bindir/kapptemplate
%_K4xdg_apps/kapptemplate.desktop
#%_K4apps/kapptemplate/
%_K4apps/kdevappwizard/
%_K4cfg/kapptemplate.kcfg
%_K4iconsdir/hicolor/*/*/kapptemplate.*
%_K4doc/*/kapptemplate

%files kuiviewer
%_K4bindir/kuiviewer
%_K4libdir/kde4/kuiviewerpart.so
%_K4xdg_apps/kuiviewer.desktop
%_K4apps/kuiviewer/
%_K4iconsdir/hicolor/*/apps/kuiviewer.png
%_K4apps/kuiviewerpart/
%_K4srv/kuiviewer_part.desktop

%files scripts
%_K4bindir/adddebug
%_K4bindir/build-progress.sh
%_K4bindir/draw_lib_dependencies
%_K4bindir/cheatmake
%_K4bindir/colorsvn
%_K4bindir/create_cvsignore
%_K4bindir/create_makefile
%_K4bindir/create_makefiles
%_K4bindir/create_svnignore
%_K4bindir/cvs-clean
%_K4bindir/cvsaddcurrentdir
%_K4bindir/cvsbackport
%_K4bindir/cvsblame
%_K4bindir/cvscheck
%_K4bindir/cvsforwardport
%_K4bindir/cvslastchange
%_K4bindir/cvslastlog
%_K4bindir/cvsrevertlast
%_K4bindir/cvsversion
%_K4bindir/cxxmetric
%_K4bindir/extend_dmalloc
%_K4bindir/extractattr
%_K4bindir/extractrc
%_K4bindir/findmissingcrystal
%_K4bindir/fix-include.sh
%_K4bindir/fixkdeincludes
%_K4bindir/fixuifiles
%_K4bindir/includemocs
%_K4bindir/kde_generate_export_header
%_K4bindir/kde-systemsettings-tree.py
%_K4bindir/kdedoc
%_K4bindir/kdekillall
%_K4bindir/kdelnk2desktop.py
%_K4bindir/kdemangen.pl
%_K4bindir/krazy-licensecheck
%_K4bindir/makeobj
%_K4bindir/noncvslist
%_K4bindir/nonsvnlist
%_K4bindir/optimizegraphics
%_K4bindir/package_crystalsvg
%_K4bindir/png2mng.pl
%_K4bindir/pruneemptydirs
%_K4bindir/qtdoc
%_K4bindir/reviewboard-am
%_K4bindir/svnclean
%_K4bindir/svnbackport
%_K4bindir/svnchangesince
%_K4bindir/svnforwardport
%_K4bindir/svngettags
%_K4bindir/svnintegrate
%_K4bindir/svnlastchange
%_K4bindir/svnlastlog
%_K4bindir/svnrevertlast
%_K4bindir/svnversions
%_K4bindir/wcgrep
%_K4bindir/zonetab2pot.py

%files strigi-analyzer
%_K4libdir/strigi/strigi*

%files po2xml
%_K4bindir/po2xml
%_K4bindir/swappo
%_K4bindir/split2po
%_K4bindir/xml2pot

%files umbrello
%_K4bindir/umbrello
%_K4bindir/po2xmi
%_K4bindir/xmi2pot
%_K4xdg_apps/umbrello.desktop
%_K4apps/umbrello/
%_K4iconsdir/hicolor/*/apps/umbrello*
%_K4doc/*/umbrello

%files cervisia
%_K4bindir/cervisia
%_K4xdg_apps/cervisia.desktop
%_K4apps/cervisia/
%_K4apps/cervisiapart/
%_K4cfg/cervisiapart.kcfg
%_K4iconsdir/*/*/apps/cervisia.*
%_K4libdir/libkdeinit4_cervisia.so
%_K4libdir/kde4/cervisiapart.so
%_K4srv/cvsservice.desktop
%_K4srv/cervisiapart.desktop
%_K4doc/*/cervisia
%if_enabled kio_svn
%_K4bindir/kio_svn_helper
%_K4libdir/kde4/kded_ksvnd.so
%_K4libdir/kde4/kio_svn.so
%_K4srv/svn*.protocol
%_K4srv/ServiceMenus/subversion*.desktop
%_K4srv/kded/ksvnd.desktop
%endif

%files kompare
%_K4bindir/kompare
%_K4libdir/kde4/komparenavtreepart.so
%_K4libdir/kde4/komparepart.so
%_K4libdir/libkomparedialogpages.so.*
%_K4xdg_apps/kompare.desktop
%_K4apps/kompare/
%_K4iconsdir/hicolor/*/apps/kompare.*
%_K4srv/komparenavtreepart.desktop
%_K4srv/komparepart.desktop
%_K4srvtyp/komparenavigationpart.desktop
%_K4srvtyp/kompareviewpart.desktop
%_K4doc/*/kompare

%files kmtrace
%_K4bindir/kmtrace
%_K4bindir/demangle
%_K4bindir/kminspector
%_K4bindir/kmmatch
%_K4apps/kmtrace/

%files kcachegrind
%_K4bindir/kcachegrind
%_K4bindir/dprof2calltree
%_K4bindir/hotshot2calltree
%_K4bindir/memprof2calltree
%_K4bindir/op2calltree
%_K4bindir/pprof2calltree
%_K4iconsdir/*/*/*/kcachegrind.*
%_K4apps/kcachegrind/
%_K4xdg_apps/kcachegrind.desktop
%_K4doc/*/kcachegrind

%files -n libkompareinterface4
%_K4libdir/libkompareinterface.so.*
%files -n libktrace4
%_K4libdir/libktrace.so.*

%files devel
%_K4includedir/kprofilemethod.h
%_K4includedir/ktrace.h
%_K4includedir/kompare/
%_K4includedir/okteta1/
%_K4includedir/kasten2/
%_K4includedir/KDE/*
%_K4link/*.so
%_K4lib/plugins/designer/*.so
%if_enabled kio_svn
%_datadir/dbus-1/interfaces/org.kde.ksvnd.xml
%endif
%_datadir/dbus-1/interfaces/org.kde.cervisia.*.xml


%changelog
