%define _unpackaged_files_terminate_build 1
%define oname kdesvn
Name: kdesvn-kde3
Version: 1.0.6
Release: alt5

Summary: A subversion client for the KDE with KIO integration

License: GPL
Url: http://www.alwins-world.de/wiki/programs/kdesvn
# There should be a better place
Group: Development/Other
Packager: Boris Savelev <boris@altlinux.ru>
Source: %oname-%version.tar.bz2
Patch: kdesvn-1.0.0-asneeded.patch
Patch1: kde-svn-alt-compile-fix.patch
Patch2: kdesvn-1.0.6-buildTDE.patch
Patch3: kdesvn-detect-gcc5-version.patch

BuildPreReq: cmake libsqlite3-devel libexpat-devel
BuildPreReq: gcc-c++ kdelibs-devel libsubversion-devel xml-utils
Conflicts: kdesvn

%description
Kdesvn is a subversion client for KDE.
It may used as standalone application or plugin (KPart). Base functions are provided
via a KIO protocol, too.

%package kiosvn
Group: Development/Other
Summary: A kde-kio integration for subversion based on kdesvn
Requires: %name = %version-%release
Conflicts: kdesdk-kio-svn
Provides: kio-svn

%description kiosvn
KIO integration (KIO::svn) based on kdesvn alternative protocol name.

%package -n libsvnqt3
Group: System/Libraries
Summary: Wrapper lib for subversion QT integration

%description -n libsvnqt3
Shared lib which contains a QT C++ wrapper for subversion. It is core part
of kdesvn but is designed to not require KDE so plain QT programs may use
it.

%package -n libsvnqt3-devel
Group: Development/C++
Summary: Wrapper lib for subversion QT integration
Requires: libsvnqt3 = %version
Conflicts: libsvnqt-devel

%description -n libsvnqt3-devel
Development files for libsvnqt

%prep
%setup -n %oname-%version
%patch -p1
%patch2 -p1
%patch3 -p2

# gentoo
# Force kdesvn to recognize kio_svn protocol name instead of kio_ksvn
# (this way we can reuse .protocol files from kdesdk-kioslaves, avoiding
# collision)
grep -rle "kio_ksvn" * | xargs sed -i -e "s:kio_ksvn:kio_svn:"


%build
export QTDIR=%_qt3dir
export KDEDIR=%_K3prefix
BD=%_builddir/%name-%version/BUILD
export PATH=$QTDIR/bin:$KDEDIR/bin:$PATH

if ! [ -f $BD/CMakeCache.txt ]
then
%K3cmake -DCMAKE_BUILD_TYPE=RelWithDebInfo -DCMAKE_INSTALL_PREFIX=/usr
fi
%K3make

%install
%K3install

%find_lang --with-kde %oname

%files -f %oname.lang
%_bindir/kdesvn
%_bindir/kdesvnaskpass
%_man1dir/kdesvn.1*
%_man1dir/kdesvnaskpass.1*
%_Kmenudir/kdesvn.desktop
%_Kapps/kconf_update/*
%_Kapps/kdesvn/
%_Kapps/kdesvnpart/
%_Kapps/konqueror/servicemenus/*.desktop
%_libkde/kded_kdesvnd.*
%_libkde/libkdesvnpart.*
%_Kcfg/kdesvn_part.kcfg
%_Kservices/kded/kdesvnd.desktop
%_iconsdir/*/*/*/*.png
%_iconsdir/*/*/*/*.svgz

%files kiosvn
%_libkde/kio_svn.*
%_Kservices/*.protocol

%files -n libsvnqt3
%_libdir/libsvnqt.so.*

%files -n libsvnqt3-devel
%_libdir/libsvnqt.so
%_includedir/svnqt

%changelog
