%undefine __libtoolize
%define _optlevel s
%define _keep_libtool_files 1

%define qtdir %_qt3dir
%define unstable 0
%add_findpackage_path %_K3bindir
%add_findprov_lib_path %_libdir/kde3

Name: kdetoys
Version: 3.5.13.2
Release: alt2.1

Group: Graphical desktop/KDE
Summary: K Desktop Environment - Toys and Amusements
URL: http://www.kde.org/
License: GPL

Source: kdetoys-%version.tar
#
Patch10: kdetoys-3.1.0-kweather_start_hack.patch
Patch11: tde-3.5.13-build-defdir-autotool.patch
Patch12: cvs-auto_version_check.patch

Requires: %name-amor = %version-%release
Requires: %name-eyes = %version-%release
Requires: %name-fifteen = %version-%release
Requires: %name-kmoon = %version-%release
Requires: %name-kodo = %version-%release
Requires: %name-kteatime = %version-%release
Requires: %name-ktux = %version-%release
Requires: %name-kweather = %version-%release
Requires: %name-kworldclock = %version-%release

# Automatically added by buildreq on Tue Apr 09 2002
#BuildRequires: XFree86-devel XFree86-libs freetype2 gcc-c++ kde-common kdebase kdelibs-devel libarts-devel libjpeg-devel liblcms libmng libpng-devel libqt3-devel libstdc++-devel libtiff-devel zlib-devel

BuildRequires(pre): kdelibs-devel
BuildRequires: gcc-c++ kde-common
#BuildRequires: kdebase
BuildRequires: libjpeg-devel liblcms libmng libpng-devel libqt3-devel
BuildRequires: libstdc++-devel libtiff-devel zlib-devel libart_lgpl-devel
BuildRequires: libpcre-devel
BuildRequires: libacl-devel libattr-devel
#BuildRequires: kdelibs-devel-cxx = %__gcc_version_base
BuildRequires: kdelibs >= %version kdelibs-devel >= %version

%description
Toys for the K Desktop Environment.

Software included in this package are:
	- amor: Amusing Misuse Of Resources put's comic figures above your windows
	- eyes: a kicker applet similar to XEyes
	- fifteen: kicker applet, order 15 pieces in a 4x4 square by moving them
	- kmoon: system tray applet showing the moon phase
	- kodo: mouse movement meter
	- kteatime: system tray applet that makes sure your tea doesn't get too strong
	- ktux: Tux-in-a-Spaceship screen saver
	- kweather: kicker applet that will display the current weather outside
	- kworldwatch: application and kicker applet showing daylight area on the world globe

%package common
Summary: Common empty package for %name
Group: Graphical desktop/KDE
Requires: kde-common >= 3.2
Conflicts: kdetoys <= 3.1.0-alt2
#
%description common
Common empty package for %name

%package devel
Summary: Headers files for kdetoys
Group: Development/KDE and QT
Requires: %name-common = %version-%release
Requires: %name-amor = %version-%release

%description devel
Headers files for kdetoys.

%package amor
Summary: Put's comic figures above your windows
Group: Toys
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
#
%description amor
Amusing Misuse Of Resources put's comic figures above your windows

%package eyes
Summary: KDE kicker applet similar to XEyes
Group: Toys
Requires: kdebase-wm, %{get_dep kdelibs}
Requires: %name-common = %version-%release
#
%description eyes
KDE kicker applet similar to XEyes

%package fifteen
Summary: KDE kicker applet, order 15 pieces in a 4x4 square by moving them
Group: Toys
Requires: kdebase-wm, %{get_dep kdelibs}
Requires: %name-common = %version-%release
#
%description fifteen
KDE kicker applet, order 15 pieces in a 4x4 square by moving them

%package kmoon
Summary: KDE system tray applet showing the moon phase
Group: Toys
Requires: kdebase-wm, %{get_dep kdelibs}
Requires: %name-common = %version-%release
#
%description kmoon
KDE system tray applet showing the moon phase

%package kodo
Summary: Mouse movement meter
Group: Toys
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
#
%description kodo
Mouse movement meter

%package kteatime
Summary: KDE applet that makes sure your tea doesn't get too strong
Group: Toys
Requires: kdebase-wm, %{get_dep kdelibs}
Requires: %name-common = %version-%release
#
%description kteatime
KDE system tray applet that makes sure your tea
doesn't get too strong

%package ktux
Summary: Tux-in-a-Spaceship screen saver for KDE
Group: Toys
Requires: kdebase-wm, %{get_dep kdelibs}
Requires: %name-common = %version-%release
#
%description ktux
Tux-in-a-Spaceship screen saver for KDE

%package kweather
Summary: KDE kicker applet to display the current weather
Group: Toys
Requires: kdebase-wm, %{get_dep kdelibs}
Requires: %name-common = %version-%release
#
%description kweather
KDE kicker applet that will display the current weather outside

%package kworldclock
Summary: Showing daylight area on the world globe
Group: Toys
Requires: %{get_dep kdelibs}
Requires: %name-common = %version-%release
#
%description kworldclock
Application and KDE kicker applet showing daylight area
on the world globe

%prep
%setup -q -n kdetoys-%version
##cp -ar altlinux/admin ./
#%patch10 -p1
%patch11
%patch12

sed -i '\|\${kdeinit}_LDFLAGS[[:space:]]=[[:space:]].*-no-undefined|s|-no-undefined|-no-undefined -Wl,--warn-unresolved-symbols|' admin/am_edit
for f in `find $PWD -type f -name Makefile.am`
do
    sed -i -e '\|_la_LDFLAGS.*[[:space:]]-module[[:space:]]|s|-module|-module \$(KDE_PLUGIN)|' $f
    #sed -i -e '\|_la_LDFLAGS.*[[:space:]]-no-undefined|s|-no-undefined|-no-undefined -Wl,--allow-shlib-undefined|' $f
    grep -q -e 'lib.*SOURCES' $f || continue
    RPATH_LINK_OPTS+=" -Wl,-rpath-link,`dirname $f`/.libs"
done
##sed -i "s|\(-Wl,--as-needed\)| $RPATH_LINK_OPTS \1|g" admin/acinclude.m4.in
##sed -i -e 's|\$USER_INCLUDES|-I%_includedir/tqtinterface \$USER_INCLUDES|' admin/acinclude.m4.in

find ./ -type f -name Makefile.am | \
while read f
do
    sed -i -e 's|\(.*_la_LIBADD[[:space:]]*\)=\(.*\)|\1= -lDCOP -lkdefx \$(LIB_KUTILS) \$(LIB_KHTML) \$(LIB_KIO) \$(LIB_KDEUI) \$(LIB_KDECORE) \$(LIB_QT) \2|' $f
done

cp -Rp /usr/share/libtool/aclocal/libtool.m4 admin/libtool.m4.in
cp -Rp /usr/share/libtool/config/ltmain.sh admin/ltmain.sh
make -f admin/Makefile.common cvs ||:


%build
rm -rf %buildroot
export QTDIR=%qtdir
export KDEDIR=%prefix

export PATH=$QTDIR/bin:$KDEDIR/bin:$PATH

export LD_LIBRARY_PATH=$QTDIR/%_lib:$KDEDIR/%_lib:$LD_LIBRARY_PATH
export LDFLAGS="-L%buildroot/%_libdir -L%buildroot/%_libdir/kde3 -L%_libdir"
%K3configure \
    --disable-gcc-hidden-visibility \
%if %unstable
    --enable-debug=full \
%else
    --disable-debug \
%endif
    --enable-final

sed -ri 's/^(hardcode_libdir_flag_spec|runpath_var)=.*/\1=/' libtool
%make_build

%install
%if %unstable
%set_strip_method none
%endif

%K3install


%files
%files common

%files amor
%_K3bindir/amor
%_K3apps/amor
%_kde3_iconsdir/hicolor/*/apps/amor.png
%doc %_K3doc/en/amor
%_K3xdg_apps/amor.desktop

%files eyes
%_K3lib/eyes_panelapplet.so*
%_K3apps/kicker/applets/eyesapplet.desktop

%files fifteen
%_K3lib/fifteen_panelapplet.so*
%_K3apps/kicker/applets/kfifteenapplet.desktop

%files kmoon
%_K3lib/kmoon_panelapplet.so*
%_K3apps/kmoon
%_kde3_iconsdir/hicolor/*/apps/kmoon.png
%_K3apps/kicker/applets/kmoonapplet.desktop
%doc %_K3doc/en/kmoon/

%files kodo
%_K3bindir/kodo
%_K3xdg_apps/kodo.desktop
%_K3apps/kodo
%_kde3_iconsdir/hicolor/*/apps/kodo.png
%doc %_K3doc/en/kodo/

%files kteatime
%_K3bindir/kteatime
%_K3xdg_apps/kteatime.desktop
%_K3apps/kteatime
%doc %_K3doc/en/kteatime/
%_kde3_iconsdir/hicolor/*/apps/kteatime.png

%files ktux
%_K3bindir/ktux
%_K3applnk/System/ScreenSavers/ktux.desktop
%_K3apps/ktux
%_kde3_iconsdir/hicolor/*/apps/ktux.png

%files kweather
%_K3bindir/kweatherservice
%_K3bindir/kweatherreport
%_K3libdir/libkdeinit_kweatherreport.so*
%_K3lib/weather_panelapplet.so*
%_K3lib/kcm_weather.so*
%_K3lib/kcm_weatherservice.so*
%_K3lib/kweatherreport.so*
%_K3apps/kicker/applets/kweather.desktop
%_K3apps/kweather
%_K3apps/kweatherservice
%_K3srv/k*weather*.desktop
%_kde3_iconsdir/hicolor/*/apps/kweather.png
%doc %_K3doc/en/kweather/

%files kworldclock
%_K3bindir/kworldclock
%_K3lib/ww_panelapplet.so*
%_K3xdg_apps/kworldclock.desktop
%_K3apps/kdesktop/programs/kdeworld.desktop
%_K3apps/kicker/applets/kwwapplet.desktop
%_K3apps/kworldclock
%_kde3_iconsdir/hicolor/*/apps/kworldclock.png
%doc %_K3doc/en/kworldclock/

%files devel
%if %_keep_libtool_files
#%_K3libdir/*.la
%endif
%_K3includedir/*.h


%changelog
