%define _localstatedir %_var

%def_enable lvs
%def_enable vrrp
%def_enable snmp
%def_enable sha1
%def_enable routes
%def_enable libiptc
%def_enable libipset
%def_enable libnl

Name: keepalived
Version: 1.4.5
Release: alt1%ubt

Summary: The main goal of the keepalived project is to add a strong & robust keepalive facility to the Linux Virtual Server project.
License: GPL
Group: Networking/Other
Url: http://www.keepalived.org/software/
Source0: %url/%name-%version.tar
Source1: %name.init

Patch2: 0002-update-systemd-unit-file.patch
BuildRequires(pre):rpm-build-ubt

# Automatically added by buildreq on Thu Aug 09 2007 (-ba)
BuildRequires: libpopt-devel libssl-devel
%{?_enable_libiptc:BuildRequires: pkgconfig(libiptc)}
%{?_enable_libipset:BuildRequires: libipset-devel}
%{?_enable_libnl:BuildRequires: pkgconfig(libnl-genl-3.0) pkgconfig(libnl-route-3.0)}
BuildRequires: libnfnetlink-devel
%{?_enable_snmp:BuildRequires: libnet-snmp-devel}

%description
The main goal of the keepalived project is to add a strong & robust keepalive
facility to the Linux Virtual Server project. This project is written in C with
multilayer TCP/IP stack checks. Keepalived implements a framework based on three
family checks : Layer3, Layer4 & Layer5/7. This framework gives the daemon the
ability of checking a LVS server pool states. When one of the server of the LVS
server pool is down, keepalived informs the linux kernel via a setsockopt call
to remove this server entrie from the LVS topology. In addition keepalived implements
an independent VRRPv2 stack to handle director failover. So in short keepalived is a
userspace daemon for LVS cluster nodes healthchecks and LVS directors failover.

%prep
%setup -q
%patch2 -p1

%build
%autoreconf
%configure \
        --with-kernel-dir=/usr/include \
        %{subst_enable lvs} \
        %{subst_enable vrrp} \
        %{subst_enable sha1} \
        %{subst_enable routes} \
        %{subst_enable libiptc} \
        %{subst_enable libipset} \
        %{subst_enable libnl} \
        %{?_enable_snmp:--enable-snmp --enable-snmp-rfc} \
        --with-init=systemd
GIT_TIMESTAMP=`cat gitstamp`
printf '#define GIT_DATE        "%s"\n' `date -d "1970-01-01 UTC $GIT_TIMESTAMP seconds" +"%m/%d,%Y"` >lib/git-commit.h
printf '#define GIT_YEAR        "%s"\n' `date -d "1970-01-01 UTC $GIT_TIMESTAMP seconds" +"%Y"` >>lib/git-commit.h

%make_build

%install
#makeinstall_std
mkdir -p %buildroot{%_sbindir,%_initdir,%_unitdir,%_sysconfdir/%name,%_sysconfdir/sysconfig}
install -pD -m755 bin/genhash %buildroot%_sbindir/genhash
install -pD -m755 bin/keepalived %buildroot%_sbindir/keepalived
mkdir -p %buildroot/%_mandir/man{1,5,8}
install -pD -m644 doc/man/man1/genhash.1 %buildroot%_man1dir/genhash.1
install -pD -m644 doc/man/man5/keepalived.conf.5 %buildroot%_man5dir/keepalived.conf.5
install -pD -m644 doc/man/man8/keepalived.8 %buildroot%_man8dir/keepalived.8
install -pD -m755 %SOURCE1 %buildroot%_initdir/%name
install -pD -m644 keepalived/%name.service %buildroot%_unitdir/%name.service
install -pD -m644 keepalived/etc/sysconfig/%name %buildroot%_sysconfdir/sysconfig/%name


%preun
%preun_service keepalived

%post
%post_service keepalived

%files
%_sbindir/*
%_man1dir/genhash.*
%_man5dir/keepalived.conf.*
%_man8dir/keepalived.*
%_initdir/%name
%_unitdir/%name.service
%dir %_sysconfdir/%name
# %config(noreplace) %_sysconfdir/%name/*
%config(noreplace) %_sysconfdir/sysconfig/%name

%doc AUTHOR ChangeLog README.md
%doc doc/keepalived.conf.SYNOPSIS
%doc doc/*-MIB*
%doc doc/*.txt
%doc doc/samples

%changelog
