Name: kernel-build-tools
Version: 0.107
Release: alt0.M80P.1

Summary: Utilities to build kernel packages for ALT Linux
License: GPL
Group: Development/Kernel
Packager: Kernel Maintainers Team <kernel@packages.altlinux.org>

Source: %name-%version.tar

Requires: rpm-build-kernel = %version-%release

# due to RPM macro expansion support
Requires: gear >= 1.3.1

# Automatically added by buildreq on Mon Apr 14 2008
BuildRequires: asciidoc help2man python-modules-encodings

%package -n rpm-build-kernel
Summary: RPM macros to build kernel packages
Group: Development/Kernel
Conflicts: rpm-build < 4.0.4-alt1

%ifnarch %ix86
Provides: kernel-headers-modules-std-pae
%endif
%ifnarch %ix86 x86_64
Provides: kernel-headers-modules-std-def
Provides: kernel-headers-modules-un-def
Provides: kernel-headers-modules-ovz-el
Provides: kernel-headers-modules-ovz-el7
%endif
%ifnarch aarch64
Provides: kernel-headers-modules-mp
%endif
%ifnarch %e2k
Provides: kernel-headers-modules-elbrus-def
%endif
%ifnarch e2k
Provides: kernel-headers-modules-elbrus-4c
%endif
%ifnarch e2kv4
Provides: kernel-headers-modules-elbrus-1cp
Provides: kernel-headers-modules-elbrus-8c
%endif

%description
Utilities to facilitate creation of kernel and additional module packages
according to ALT Linux kernel packaging conventions.

%description -n rpm-build-kernel
RPM macros used to build kernel packages according to ALT Linux
kernel packaging conventions.

%prep
%setup

%build
%make_build
asciidoc README.ru.koi8

%install
%makeinstall_std
install -Dpm644 kernel-macros \
	%buildroot%_rpmmacrosdir/kernel
install -Dpm0755 query-kEVR.sh \
	-t %buildroot%_rpmlibdir/

%files
%_bindir/*
%_mandir/man?/*
%doc README* config.sh.sample kernel-policy.txt kernel-spec-example.txt

%files -n rpm-build-kernel
%_rpmmacrosdir/kernel
%_rpmlibdir/query-kEVR.sh

%changelog
