%define module_name	virtualbox-addition
%define module_version  5.1.30
%define module_release	alt2

%define flavour		std-pae
BuildRequires(pre): rpm-build-kernel >= 0.100-alt1
BuildRequires(pre): kernel-headers-modules-std-pae

%setup_kernel_module %flavour

%define module_dir /lib/modules/%kversion-%flavour-%krelease/misc

%define guest_module_name	vboxguest
%define vfs_module_name		vboxsf
%define video_module_name	vboxvideo

Summary: VirtualBox modules
Name: kernel-modules-%module_name-%flavour
Version: %module_version
Release: %module_release.%kcode.%kbuildrelease
License: GPL
Group: System/Kernel and hardware

Packager: Kernel Maintainer Team <kernel@packages.altlinux.org>

ExclusiveOS: Linux
Url: http://www.virtualbox.org/

BuildPreReq: gcc-c++
BuildRequires: perl
BuildRequires: rpm >= 4.0.2-75
BuildRequires: kernel-headers-modules-%flavour = %kepoch%kversion-%krelease
BuildRequires: kernel-source-%guest_module_name = %module_version
BuildRequires: kernel-source-%vfs_module_name = %module_version
BuildRequires: kernel-source-%video_module_name = %module_version

Provides: kernel-modules-%module_name-%kversion-%flavour-%krelease = %version-%release
Conflicts: kernel-modules-%module_name-%kversion-%flavour-%krelease < %version-%release
Conflicts: kernel-modules-%module_name-%kversion-%flavour-%krelease > %version-%release

Provides: kernel-modules-%guest_module_name-%kversion-%flavour-%krelease = %version-%release
Provides: kernel-modules-%guest_module_name-%flavour = %version-%release

Provides: kernel-modules-%video_module_name-%kversion-%flavour-%krelease = %version-%release
Provides: kernel-modules-%video_module_name-%flavour = %version-%release

Provides: kernel-modules-%vfs_module_name-%kversion-%flavour-%krelease = %version-%release
Provides: kernel-modules-%vfs_module_name-%flavour = %version-%release
Obsoletes: kernel-modules-%vfs_module_name-%flavour

PreReq: kernel-image-%flavour = %kepoch%kversion-%krelease
ExclusiveArch: %karch

# %%if "%flavour" == "ovz-el"
# #Patch1: ovz-el-fix-build.patch
# %%endif

%description
This package contains VirtualBox addition modules (vboxguest, vboxsf, vboxvideo)
that are needed for additonal guests support for VirtualBox.

%prep
%setup -T -c -n kernel-source-%module_name-%module_version
tar jxvf %kernel_src/kernel-source-%guest_module_name-%module_version.tar.bz2
tar jxvf %kernel_src/kernel-source-%vfs_module_name-%module_version.tar.bz2
#pushd kernel-source-%vfs_module_name-%module_version
#%patch1 -p7
#popd
tar jxvf %kernel_src/kernel-source-%video_module_name-%module_version.tar.bz2

# %%if "%flavour" == "ovz-el"
# %%patch1 -p1
# %%endif

%build
. %_usrsrc/linux-%kversion-%flavour/gcc_version.inc
%make -C kernel-source-%guest_module_name-%module_version \
    KERN_DIR=%_usrsrc/linux-%kversion-%flavour/
cp kernel-source-%guest_module_name-%module_version/Module.symvers \
    kernel-source-%vfs_module_name-%module_version
%make -C kernel-source-%vfs_module_name-%module_version \
    KERN_DIR=%_usrsrc/linux-%kversion-%flavour/
cp kernel-source-%guest_module_name-%module_version/Module.symvers \
    kernel-source-%video_module_name-%module_version
%make -C kernel-source-%video_module_name-%module_version \
    KERN_DIR=%_usrsrc/linux-%kversion-%flavour/

%install
mkdir -p %buildroot/%module_dir
install -pD -m644 kernel-source-%guest_module_name-%module_version/vboxguest.ko \
    %buildroot%module_dir/
install -pD -m644 kernel-source-%vfs_module_name-%module_version/vboxsf.ko \
    %buildroot%module_dir/
install -pD -m644 kernel-source-%video_module_name-%module_version/vboxvideo.ko \
    %buildroot%module_dir/

%files
%defattr(644,root,root,755)
%module_dir

%changelog
