%define vermajor 1
%define verminor 5.10
%define version %vermajor.%verminor

Name: keyutils
Version: %version
Release: alt0.M80P.2

Summary: Linux Key Management Utilities
License: GPL/LGPL
Group: System/Base
Url: http://people.redhat.com/~dhowells/keyutils/

Source0: %name-%version-%release.tar

BuildRequires: glibc-kernheaders

%description
Utilities to control the kernel key management facility and to provide
a mechanism by which the kernel call back to userspace to get a key
instantiated.

%package -n lib%name
Summary: Key utilities library
Group: System/Libraries

%package -n lib%name-devel
Summary: Development package for building linux key management utilities
Group: Development/C
Requires: lib%name == %version-%release

%description -n lib%name
This package provides a wrapper library for the key management facility system
calls.

%description -n lib%name-devel
This package provides headers and libraries for building key utilities.

%prep
%setup

%build
make \
    NO_ARLIB=1 \
    LIBDIR=/%_lib \
    USRLIBDIR=%_libdir \
    RELEASE=.%release \
    NO_GLIBC_KEYERR=1 \
    CFLAGS="-Wall $RPM_OPT_FLAGS -Werror"

%install
make \
    NO_ARLIB=1 \
    DESTDIR=%buildroot \
    LIBDIR=/%_lib \
    USRLIBDIR=%_libdir \
    install
ln -snf ../../%_lib/lib%name.so.1 %buildroot%_libdir/lib%name.so

%files
%doc README LICENCE.GPL
%config(noreplace) %_sysconfdir/request-key.conf
%dir %_sysconfdir/request-key.d
/sbin/*
/bin/*
%_datadir/%name
%_man1dir/*
%_man5dir/*
%_man7dir/*
%_man8dir/*

%files -n lib%name
/%_lib/lib%name.so.*

%files -n lib%name-devel
%_libdir/lib%name.so
%_includedir/*
%_man3dir/*

%changelog
