%define rname kservice

Name: kf5-%rname
Version: 5.49.0
Release: alt1%ubt
%K5init altplace

Group: System/Libraries
Summary: KDE Frameworks 5 plugin framework for desktop services
Url: http://www.kde.org
License: GPLv2+ / LGPLv2+

Source: %rname-%version.tar
Patch1: alt-skip-antikde-mimeapps-list.patch
Patch2: alt-initial-preference.patch

# Automatically added by buildreq on Thu Feb 12 2015 (-bi)
# optimized out: cmake cmake-modules docbook-dtds elfutils kf5-kdoctools-devel libEGL-devel libGL-devel libcloog-isl4 libgpg-error libqt5-core libqt5-dbus libqt5-gui libqt5-widgets libqt5-x11extras libqt5-xml libstdc++-devel libxcbutil-keysyms python-base ruby ruby-stdlibs xml-common xml-utils
#BuildRequires: docbook-style-xsl extra-cmake-modules gcc-c++ kf5-karchive-devel kf5-kconfig-devel kf5-kcoreaddons-devel kf5-kcrash-devel kf5-kdbusaddons-devel kf5-kdoctools kf5-kdoctools-devel-static kf5-ki18n-devel kf5-kwindowsystem-devel python-module-google qt5-base-devel rpm-build-ruby
BuildRequires(pre): rpm-build-kf5 rpm-build-ubt
BuildRequires: extra-cmake-modules qt5-base-devel
BuildRequires: docbook-style-xsl flex bison
BuildRequires: kf5-karchive-devel kf5-kconfig-devel kf5-kcoreaddons-devel kf5-kcrash-devel
BuildRequires: kf5-kdbusaddons-devel kf5-kdoctools kf5-kdoctools-devel-static
BuildRequires: kf5-ki18n-devel kf5-kwindowsystem-devel

%description
KService provides a plugin framework for handling desktop services. Services can
be applications or libraries. They can be bound to MIME types or handled by
application specific code.

%package common
Summary: %name common package
Group: System/Configuration/Other
BuildArch: noarch
Requires: kf5-filesystem
%description common
%name common package

%package devel
Group: Development/KDE and QT
Summary: Development files for %name
Requires: kf5-kconfig-devel
Requires: kf5-kcoreaddons-devel
%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package -n libkf5service
Group: System/Libraries
Summary: KF5 library
Requires: %name-common = %version-%release
Requires: altlinux-freedesktop-menu-generic
%description -n libkf5service
KF5 library


%prep
%setup -n %rname-%version
%patch1 -p1
%patch2 -p1

%build
%K5build ||:
# hack against ALTBUG#32378
sed -i '/num_to_alloc.*\/\//s|//\(.*\)|/* \1 */|' BUILD//src/lex.c
%K5make

%install
%K5install
%find_lang %name --all-name
%K5find_qtlang %name --all-name

%files common -f %name.lang
%doc COPYING.LIB README.md
%config(noreplace) %_K5xdgconf/*.*categories

%files devel
%_K5inc/kservice_version.h
%_K5inc/KService/
%_K5link/lib*.so
%_K5lib/cmake/KF5Service
%_K5archdata/mkspecs/modules/qt_KService.pri

%files -n libkf5service
%_bindir/kbuildsycoca5
%_K5bin/kbuildsycoca5
%_K5lib/libKF5Service.so.*
%_K5srvtyp/*.desktop

%changelog
