%set_automake_version 1.11

Name: knetload
Version: 2.9.92
Release: alt1
Serial: 1

Group: Monitoring
Summary: Network traffic monitor for KDE3/TDE Kicker
URL: http://www.flameeyes.eu/oldstuff
License: %gpl2only

Source: %name-%version.tar.bz2
Source1: %name-Makefile.am

Patch1: %name-2.9.92-automake.patch

Patch10: %name-2.9.92-kcfg.diff
Patch11: %name-2.9.92-if-name.diff

# Automatically added by buildreq on Mon Dec 22 2014 (-bi)
# optimized out: elfutils fontconfig gnu-config imake kdebase-common kdelibs kdelibs-devel kdepim-libs libICE-devel libSM-devel libX11-devel libXext-devel libXt-devel libpng-devel libqt3-devel libqt3-settings libstdc++-devel libtqt-devel pkg-config python-base xml-utils xorg-cf-files xorg-xproto-devel zlib-devel
BuildRequires: doxygen gcc-c++ graphviz kde-i18n-ru kdepim-devel libjpeg-devel xdg-user-dirs

BuildRequires: rpm-build-licenses rpm-macros-kde-common-devel rpm-macros-qt3

%description
This is a network throughput meter for Kicker (the KDE3/TDE Panel).
It will show the traffic on a network device with two diagrams, one
for outgoing and one for incoming data.

Since version 3, KNetLoad is now a true full-integrated Kicker applet,
no more the old standalone application which resides on the system
tray. This change allow you to have bigger, more readable graphs, and
also allow you to add more than one interface monitored at a time.

%prep
%setup -q
%patch1 -p1

%patch10 -p1
%patch11 -p1

make -f admin/Makefile.common cvs ||:

%build

%add_optflags -I%_includedir/tqtinterface -lkdeui -lkdecore -L%_qt3dir/lib -lqt-mt -fPIC -DPIC

%K3configure \
    --enable-final \
    --enable-shared \
    --disable-static \
    --disable-rpath \
    --program-transform-name=""

%make_build

pushd knetload/.libs
g++ -shared -L%_qt3dir/lib -o libknetloadapplet.so *.o -lkdeui -lkdecore -lqt-mt -lpthread
popd

%install
%K3install PACKAGE=%name

pushd %buildroot/%_K3doc
for DIR in `ls -d *`; do
    pushd $DIR
    NAME=`ls -d *`
    if [ "$NAME" = "doc" ]; then
        mv $NAME %name
    fi
    popd
done
popd

mkdir %_bKlibdir
mv %buildroot/%_libdir/libknetloadapplet.so %_bKlibdir

%K3find_lang %name
echo '%lang(sr) /usr/share/kde/locale/sr@Latn/LC_MESSAGES/knetload.mo' >> %name.lang

%files -f %name.lang
%_Klibdir/libknetloadapplet.so

%_datadir/icons/crystalsvg/*/apps/%name.*

%_K3cfg/knetload.kcfg
%_kde3_iconsdir/hicolor/*/apps/*.png

%_K3apps/kicker/applets/%{name}applet.desktop

%dir %_K3apps/knetloadapplet
%dir %_K3apps/knetloadapplet/pics
%_K3apps/knetloadapplet/pics/*.png

%dir %_K3doc/*/%name
%_K3doc/*/%name/*
%doc COPYING README AUTHORS

%changelog
