Name: knock
Version: 0.7.8
Release: alt1

Summary: knock is a port-knocking client
License: GPL
Group: Networking/Remote access

Url: http://www.zeroflux.org/cgi-bin/cvstrac.cgi/knock/wiki
Source0: %name-%version.tar
Source1: knockd.sysconfig
Source2: knockd.init
Patch: %name-%version-%release.patch

# Automatically added by buildreq on Thu Feb 17 2005
BuildRequires: gcc-c++ libpcap-devel

%description
Knock is a port-knocking server/client.  Port-knocking is a method where a
server can sniff one of its interfaces for a special "knock" sequence of
port-hits.  When detected, it will run a specified event bound to that port
knock sequence.  These port-hits need not be on open ports, since we use
libpcap to sniff the raw interface traffic. This package contains the
knock client.

%package server
Group: Networking/Remote access
Summary: knockd is a port-knocking server

%description server
Knock is a port-knocking server/client.  Port-knocking is a method where a
server can sniff one of its interfaces for a special "knock" sequence of
port-hits.  When detected, it will run a specified event bound to that port
knock sequence.  These port-hits need not be on open ports, since we use
libpcap to sniff the raw interface traffic. This package contains the
knockd server.

%prep
%setup
%patch -p1

%build
autoreconf -fisv
%configure
%make_build

%install
%make_install DESTDIR=%buildroot install
install -pD -m644 %SOURCE1 %buildroot%_sysconfdir/sysconfig/knockd
install -pD -m755 %SOURCE2 %buildroot%_initdir/knockd
install -pD -m600 knockd.conf %buildroot%_sysconfdir/knockd.conf

%post server
%post_service knockd

%preun server
%preun_service knockd

%postun server
if [ "$1" -ge "1" ]; then
	/sbin/service knockd condrestart >/dev/null 2>&1 || :
fi

%files
%_bindir/%name
%_man1dir/knock.1*

%files server
%doc README.md ChangeLog TODO
%attr(0755,root,root) %_sbindir/knockd
%attr(0600,root,root) %config(noreplace) %_sysconfdir/knockd.conf
%attr(0644,root,root) %config(noreplace) %_sysconfdir/sysconfig/knockd
%attr(0755,root,root) %config %_initdir/knockd
%_sbindir/knockd
%_sbindir/knock_add
%_man1dir/knockd.1*

%changelog
