Name: kodi
Version: 17.6
Release: alt0.M80P.1

Summary: Kodi Media Center
License: GPL
Group: Video
Url: http://kodi.tv

Provides: xbmc = %version-%release
Obsoletes: xbmc

Requires: kodi-data = %version-%release

Source0: %name-%version-%release.tar
Patch1: kodi-17.6-crystalhd.patch

BuildRequires: cmake gcc-c++ doxygen swig gperf nasm unzip zip
BuildRequires: boost-devel bzlib-devel libmysqlclient-devel libSDL_image-devel libSDL_mixer-devel
BuildRequires: libXScrnSaver-devel libXau-devel libXcomposite-devel libXcursor-devel
BuildRequires: libXdmcp-devel libXext-devel libXft-devel libXmu-devel
BuildRequires: libXpm-devel libXrandr-devel libXt-devel libXtst-devel libSM-devel libxkbfile-devel
BuildRequires: libX11-devel libXfixes-devel libXrender-devel xorg-xproto-devel
BuildRequires: libalsa-devel libass-devel libavahi-devel libbluray-devel libcap-devel
BuildRequires: libcec-devel >= 4.0.0 libcdio-devel libcurl-devel libdbus-devel libenca-devel
BuildRequires: libexpat-devel libfaad-devel libflac-devel libfreetype-devel libfribidi-devel
BuildRequires: libgnutls-devel libjasper-devel libjpeg-devel liblzo2-devel libyajl-devel
BuildRequires: liblcms2-devel libmicrohttpd-devel libmms-devel libnfs-devel
BuildRequires: libpcrecpp-devel libgif-devel libpng-devel libsmbclient-devel libdcadec-devel
BuildRequires: libsqlite3-devel libtiff-devel libwavpack-devel
BuildRequires: libplist-devel libpulseaudio-devel libssh-devel python-devel
BuildRequires: libbluez-devel libtag-devel tinyxml-devel libudev-devel libuuid-devel
BuildRequires: fontconfig-devel libgcrypt-devel liblame-devel libxml2-devel libxslt-devel
BuildRequires: libcrossguid-devel libdrm-devel zlib-devel
BuildRequires: libva-devel libvdpau-devel libGL-devel libGLU-devel libGLEW-devel libEGL-devel
BuildRequires: java-1.8.0-openjdk-devel /proc
BuildRequires: libcrystalhd-devel

%package data
Summary: Kodi architecture-independent data
Group: Video
BuildArch: noarch
Provides: xbmc-data = %version-%release
Obsoletes: xbmc-data
# commonly used by external plugins
%py_requires json logging sqlite3 xml

%package devel
Summary: Kodi development part
Group: Development/C++
Requires: kodi = %version-%release

%description
Kodi is an media-player and entertainment hub for all your digital media.

%description data
Kodi is an media-player and entertainment hub for all your digital media.
This package contains all architecture-independent data requried for Kodi.

%description devel
Kodi is an media-player and entertainment hub for all your digital media.
This package contains development part of Kodi.

%define docdir %_defaultdocdir/%name-%version

%prep
%setup
%patch1 -p1

%build
export ac_cv_type__Bool=yes
[ ! -x bootstrap ] || sh bootstrap
%configure --disable-non-free \
	--enable-pulse \
	--with-ffmpeg=force \
	--with-lirc-device=/var/run/lirc/lircd \
	#

%make_build

%install
%makeinstall_std

rm -rf %buildroot%_datadir/kodi/system/players/VideoPlayer/etc

mv %buildroot%_datadir/doc/kodi %buildroot%docdir

mkdir -p \
    %buildroot%_sysconfdir/sysconfig \
    %buildroot%_sysconfdir/X11/wmsession.d \
    %buildroot%_datadir/kodi/language \
    %buildroot%_datadir/kodi/sounds

cat >%buildroot%_sysconfdir/X11/wmsession.d/20KODI << 'E_O_F'
NAME=Kodi
ICON=/usr/share/kodi/media/icon32x32.png
DESC=Kodi Media Center
EXEC=/usr/bin/kodi-standalone
SCRIPT:
exec /usr/bin/kodi-standalone
E_O_F

%add_python_req_skip xbmc
%add_python_req_skip xbmcgui
%add_python_req_skip xbmcaddon
%add_python_req_skip xbmcvfs

%set_verify_elf_method textrel=relaxed

%files
%docdir

%config(noreplace) %_sysconfdir/X11/wmsession.d/20KODI

%_bindir/kodi
%_bindir/kodi-standalone

%_datadir/xsessions/kodi.desktop
%_desktopdir/kodi.desktop
%_iconsdir/hicolor/*/apps/kodi.png

%dir %_libdir/kodi
%_libdir/kodi/system
%_libdir/kodi/addons
%_libdir/kodi/kodi.bin
%_libdir/kodi/kodi-xrandr

%files data
%dir %_datadir/kodi
%_datadir/kodi/addons
%_datadir/kodi/language
%_datadir/kodi/media
%_datadir/kodi/sounds
%_datadir/kodi/system
%_datadir/kodi/userdata
%_datadir/kodi/privacy-policy.txt

%files devel
%_includedir/kodi
%_libdir/kodi/*.cmake

%changelog
