%define ver_major 3.20
%define gtk_api_ver 3.0
%def_with pkcs11

Name: krb5-auth-dialog
Version: %ver_major.0
Release: alt1

Summary: Kerberos 5 authentication dialog
License: GPLv2+
Group: Graphical desktop/GNOME
Url: http://redhat.com

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

%define glib_ver 2.28
%define gtk_ver 3.0.0
%define nm_ver 0.8.997
%define notify_ver 0.7
%define control_center_ver 3.0.0

%{?_with_pkcs11:Requires: libopensc}

BuildPreReq: libgio-devel >= %glib_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: libnotify-devel >= %notify_ver
BuildPreReq: NetworkManager-glib-devel >= %nm_ver
BuildRequires: flex libgio-devel libkrb5-devel libcap-devel libcap-utils libpam-devel
BuildRequires: intltool yelp-tools
BuildRequires: gnome-control-center-devel >= %control_center_ver
%{?_with_pkcs11:BuildRequires: libopensc}

%description
krb5-auth-dialog is a simple dialog that monitors kerberos tickets, and
pops up a dialog when they are about to expire.

%prep
%setup

%build
%configure \
	--disable-schemas-compile \
	--disable-static \
	--enable-network-manager \
	%{?_with_pkcs11:--with-pkcs11=%_libdir/pkcs11/opensc-pkcs11.so}

%make_build

%install
%makeinstall_std
%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/*
%dir %_libdir/%name/plugins
%_libdir/%name/plugins/libka-plugin-dummy.so
%_libdir/%name/plugins/libka-plugin-pam.so
%_libdir/%name/plugins/libka-plugin-afs.so
%_libdir/%name/plugins/libka-plugin-gnomelock.so
%_datadir/applications/%name.desktop
%_datadir/dbus-1/services/org.gnome.KrbAuthDialog.service
%_iconsdir/hicolor/*/*/*.*
%_datadir/glib-2.0/schemas/org.gnome.KrbAuthDialog.gschema.xml
%_datadir/GConf/gsettings/org.gnome.KrbAuthDialog.convert
%_datadir/appdata/%name.appdata.xml
%_sysconfdir/xdg/autostart/*.desktop
%_man1dir/*
%doc AUTHORS ChangeLog NEWS README

%exclude %_libdir/%name/plugins/*.la

%changelog
