%define version 1.90.0
%define altrelease 13.2

%define appname krusader
%define srcname %appname-%{?cvs:cvs-%cvs}%{!?cvs:%version%{?pre:-%pre}}

%define qtdir %_qt3dir
%define kdedir %_K3prefix

Name: %appname
Version: %version
Release: alt%{?pre:0.%altrelease.%pre}%{!?pre:%altrelease}%{?cvs:.cvs%cvs}

Source0: %srcname.tar.gz

Patch10: krusader-cvs-20060412-makefile-kutils.patch
Patch11: tde-3.5.13-build-defdir-autotool.patch
Patch12: cvs-auto_version_check.patch
Patch13: tde-3.5.13-krarc-chdirUTF8.patch
Patch14: tde-3.5.13-rar_problem_optR.patch

Group: File tools
Summary: A twin panel file manager for kde %{?cvs:- unstable version from cvs}
License: GPL
Url: http://krusader.sourceforge.net

# Automatically added by buildreq on Mon Sep 29 2008
BuildRequires: gcc4.7-c++ imake kdebase-devel kdebindings-kjsembed-devel libXt-devel libjpeg-devel libqt3-devel xml-utils xorg-cf-files

%description
Krusader is an advanced twin-panel (commander-style) file-manager for KDE 3.x (similar to Midnight or Total Commander) but with many extras.
It provides all the file-management features you could possibly want. Plus: extensive archive handling, mounted filesystem support, FTP, advanced search module, viewer/editor, directory synchronisation, file content comparisons, powerful batch renaming and much much more.
Krusader supports the following archive formats: tar, zip, bzip2, gzip, rar, ace, arj and rpm and can handle other KIOSlaves such as smb:// or fish://.
It is (almost) completely customizable, very user friendly, fast and looks great on your desktop! :-) You should give it a try.

%prep
%setup -q -n %srcname
%patch10
%patch11
%patch12
%patch13
%patch14

cp -Rp /usr/share/libtool/aclocal/libtool.m4 admin/libtool.m4.in
cp -Rp /usr/share/libtool/config/ltmain.sh admin/ltmain.sh
make -f admin/Makefile.common

%build
rm -rf %buildroot
export QTDIR=%qtdir
export KDEDIR=%kdedir

export PATH=$QTDIR/bin:$KDEDIR/bin:$PATH

%K3configure \
        --disable-rpath \
	--disable-debug \
	--disable-static \
	--enable-shared

### SMP build is buggy! don't use make_build
%make

%install
%K3install

cp %buildroot/%_kde3_iconsdir/locolor/16x16/apps/%appname.png %buildroot/%_kde3_iconsdir

%find_lang %appname --with-kde

%files -f %appname.lang
%_K3bindir/%appname
%_K3lib/*
#%exclude %_libdir/kde3/kio_iso.*
#exclude %_libdir/kde3/kio_tar.*
# %_datadir/apps/konqueror/servicemenus/*.desktop
# %_datadir/config/*
###%%_menudir/%appname
%_K3apps/%appname
%_K3xdg_apps/*.desktop
%doc README ChangeLog TODO CVSNEWS
%doc %_K3doc/*/krusader/
%_K3iconsdir/crystalsvg/*/apps/%{appname}*
%_kde3_iconsdir/*/*/*/*.png
%_kde3_iconsdir/%name.png
%_K3srv/*.protocol
%_K3i18n/*
# %_man1dir/*

%changelog
