Name:       kup
Version:    0.3.4
Release:    alt1
Summary:    Kernel.org Uploader

Group:      Development/Tools
License:    GPLv2
URL:        https://git.kernel.org/?p=utils/kup/kup.git;a=summary
Source0:    https://www.kernel.org/pub/software/network/kup/kup-%{version}.tar.xz
Source1:    kup-server-tmpfiles.conf
BuildArch:  noarch

BuildRequires: gnupg
BuildRequires: perl-Digest-SHA
BuildRequires: perl-BSD-Resource
BuildRequires: perl-Config-Simple
BuildRequires: perl-Encode
BuildRequires: perl-Git

%description
Kup is a secure upload tool used by kernel developers to upload
cryptographically verified packages to kernel.org.

This package includes the client-side kup utility.


%package server
Summary:    Kernel.org Uploader - server utilities
Group:      Development/Tools
Requires:   gnupg, xz

%description server
Kup is a secure upload tool used by kernel developers to upload
cryptographically verified packages to kernel.org.

This package includes the server-side kup-server utility.


%package server-utils
Summary:    Kernel.org Uploader - administration tools
Group:      Development/Tools
Requires:   kup-server = %version-%release

%description server-utils
Kup is a secure upload tool used by kernel developers to upload
cryptographically verified packages to kernel.org.

This package includes additional tools to help in kup-server administration.


%prep
%setup -q

%install
mkdir -p -- \
	%buildroot/%_bindir \
	%buildroot/%_man1dir \
	%buildroot/%_sysconfdir/kup \
	%buildroot/%_localstatedir/run/kup

install -pm 0755 kup gpg-sign-all genrings kup-server %buildroot/%_bindir
install -pm 0644 kup.1 %buildroot/%_man1dir/
install -pm 0644 kup-server.cfg %buildroot/%_sysconfdir/kup/kup-server.cfg

# Runtime directories and files
mkdir -pm 0755 \
	%buildroot/%_localstatedir/kup/{pub,tmp,pgp} \
	%buildroot/%_tmpfilesdir

install -pm 0644 %SOURCE1 %buildroot/%_tmpfilesdir/kup-server.conf
touch %buildroot/%_localstatedir/run/kup/lock

%files
%doc COPYING
%_bindir/kup
%_man1dir/kup.*

%files server
%doc README test
%config(noreplace) %_tmpfilesdir/kup-server.conf
%config %dir %_sysconfdir/kup
%config(noreplace) %_sysconfdir/kup/kup-server.cfg
%_bindir/kup-server
%dir %attr(1777,root,root) %_localstatedir/kup/tmp
%dir %_localstatedir/kup
%dir %_localstatedir/kup/pgp
%dir %_localstatedir/kup/pub
%dir %_localstatedir/run/kup
%_localstatedir/run/kup/lock

%files server-utils
%_bindir/gpg-sign-all
%_bindir/genrings

%changelog
