%define oname LabPlot
%define pre .beta1
Name: labplot
Version: 2.0.1
Release: alt1.svn20140201

Summary: Function and Data Plotter

Url: http://labplot.sourceforge.net
Group: Sciences/Other
License: GPL

# https://labplot.svn.sourceforge.net/svnroot/labplot
Source: %oname-%version.tar.bz2
Source1: %name-2.0.0.desktop
Source2: CMakeCache.txt

# Automatically added by buildreq on Sun Jan 18 2009
BuildRequires: ccmake gcc-c++ kde4base-runtime kde4libs-devel
BuildRequires: libXScrnSaver-devel libXau-devel libXcomposite-devel
BuildRequires: libXdamage-devel libXdmcp-devel libXpm-devel libXt-devel
BuildRequires: libXtst-devel libXv-devel libXxf86misc-devel libcdf-devel
BuildRequires: libgsl-devel libhdf5-devel libnetcdf-devel
BuildRequires: libqt4-devel libxkbfile-devel xorg-xf86vidmodeproto-devel
BuildPreReq: chrpath bison

Conflicts: labplot1.6
Requires: ImageMagick >= 5.4.7 gsl pstoedit

%description
This is a program for plotting of functions and data manipulation.

A versatile spreadsheet for data import and editing was added. Also a better
3 dimensional plot with rotation and colormaps is available.
Newly supported are data set operations and image manipulations. One can now 
import over 80 different images formats and export directly to ps, eps or pdf.
The plots now use double buffering and LabPlot supports scripting using
QSA.

%package scidavis
Summary: Function and Data Plotter (experimental Qt frontend)
Group: Sciences/Other
Requires: ImageMagick >= 5.4.7 gsl pstoedit

%description scidavis
This is a program for plotting of functions and data manipulation.

A versatile spreadsheet for data import and editing was added. Also a better
3 dimensional plot with rotation and colormaps is available.
Newly supported are data set operations and image manipulations. One can now 
import over 80 different images formats and export directly to ps, eps or pdf.
The plots now use double buffering and LabPlot supports scripting using
QSA.

SciDAVis introduces an abstraction of the application design called
"aspect framework" or "5 layer model".

%prep
%setup -n %oname-%version
#sed -i 's|@LIBDIR@|%_libdir|g' src/qtfrontend/config.pri

install -p -m644 %SOURCE2 .
sed -i "s|@PWD@|$PWD|g" CMakeCache.txt

%ifarch x86_64
LIB64=64
%endif
sed -i "s|@64@|$LIB64|" CMakeLists.txt

%build
cmake -Wdev --debug-output -DCMAKE_INSTALL_PREFIX=%prefix .

%make_build

# build SciDAvis

#pushd src/qtfrontend
#qmake-qt4 QMAKE_CFLAGS_RELEASE="%optflags" \
#	QMAKE_CXXFLAGS_RELEASE="%optflags" scidavis.pro
#make_build
#popd

%install
%makeinstall_std

install -m644 -D %SOURCE1 %buildroot%_desktopdir/%name.desktop

mv %buildroot%_bindir/labplot2 %buildroot%_bindir/%oname
ln -s %oname %buildroot%_bindir/labplot2

# install SciDAvis

#pushd src/qtfrontend
#make_install INSTALL_ROOT=%buildroot install
#install -d %buildroot%_libdir/scidavis
#mv %buildroot%_bindir/*.so %buildroot%_libdir/scidavis
#chrpath -r %_libdir/scidavis %buildroot%_bindir/scidavis
#popd

#

%find_lang %oname --with-kde

%files -f %oname.lang
%doc AUTHORS README COPYING WISHLIST ChangeLog
%_bindir/*
#exclude %_bindir/scidavis
#_libdir/*so.*
%_datadir/apps/%{oname}2/
%_desktopdir/*
%_K4xdg_mime/*
%_datadir/icons/hicolor/*/apps/*

#files scidavis
#doc %_docdir/scidavis
#_bindir/scidavis
#_libdir/scidavis

%changelog
