Name: ladspa_sdk
Version: 1.13
Release: alt1.qa1

Summary: The Linux Audio Developer's Simple Plugin API (LADSPA)
License: LGPL
Group: Sound
Url: http://www.ladspa.org

Source: http://www.ladspa.org/download/%name.tgz
Patch0: %name-1.11-alt-makefile.patch
Patch1: %name-1.11-alt-silent.build.patch
Patch2: %name-1.11-alt-notmp_makefile.patch
Patch3: %name-1.12-alt-libs.patch
Patch4: %name-1.12-alt-gcc4.1.patch

Requires: common-licenses

# Automatically added by buildreq on Tue Dec 02 2008
BuildRequires: gcc-c++ time
Requires: rpm-macros-%{name} = %{version}-%{release}

%description
The Linux Audio Developer's Simple Plugin API (LADSPA) attempts
to give programmers the ability to write simple `plugin' audio
processors in C/C++ and link them dynamically against a range of
host applications.

%define _ladspa_path %_libdir/ladspa
%define _ladspa_datadir %_datadir/ladspa


%package -n rpm-macros-%{name}
Summary: Set of RPM macros for packaging %name-based applications
Group: Development/Other
# uncomment if macroses are platform-neutral
#BuildArch: noarch
# helps old apt to resolve file conflict at dist-upgrade (thanks to Stanislav Ievlev)
Conflicts: ladspa_sdk <= 1.13-alt1

%description -n rpm-macros-%{name}
Set of RPM macros for packaging %name-based applications for ALT Linux.
Install this package if you want to create RPM packages that use %name.

%prep
%setup -q -n %name
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1

sed -i 's,mkdirhier,mkdir -p,' src/makefile

%build
%define _optlevel 3
pushd src
%make_build CFLAGS="\$(INCLUDES) -Werror -fPIC $RPM_OPT_FLAGS"
popd

%install
mkdir -p %buildroot%_datadir/ladspa/rdf
pushd src
%make_install PREFIX=%prefix DESTDIR=%buildroot \
	INSTALL_PLUGINS_DIR=%_ladspa_path \
	install
popd

# install docs and license
rm -f doc/COPYING
ln -s -f %_licensedir/LGPL-2 COPYING
ln -s -f %_includedir/ladspa.h doc/ladspa.h.txt
ln -s -f doc/index.html index.html

# Applications using LADSPA-plugins needs environment variable LADSPA_PATH.
cat << __SH__ >ladspa.sh
# where LADSPA plugins installed
LADSPA_PATH="%_ladspa_path"
export LADSPA_PATH
__SH__

cat << __CSH__ >ladspa.csh
# where LADSPA plugins installed
setenv LADSPA_PATH "%_ladspa_path"
__CSH__

install -d %buildroot%_sysconfdir/profile.d
install -m755 ladspa.{sh,csh} %buildroot%_sysconfdir/profile.d

# Creating ladspa_sdk buildreq filter
cat <<__BUILDREQS__ > %name.buildreq
# ladspa buildreq filter.
^%_ladspa_path
__BUILDREQS__

install -pD -m644 %name.buildreq %buildroot%_sysconfdir/buildreqs/files/ignore.d/ladspa

# rpm macros for ladspa related software
cat <<__RPM_MACROS__ >ladspa.rpm_macros
%%_ladspa_path %%_libdir/ladspa
%%_ladspa_datadir %%_datadir/ladspa
__RPM_MACROS__

install -pD -m644 ladspa.rpm_macros %buildroot%_rpmlibdir/macros.d/%name

%files
%_bindir/*
%_includedir/ladspa.h
%_ladspa_path
%dir %_ladspa_datadir
%dir %_ladspa_datadir/rdf
%_sysconfdir/profile.d/*
%_rpmlibdir/macros.d/*
%config %_sysconfdir/buildreqs/files/ignore.d/*
%doc --no-dereference index.html doc README COPYING
%exclude %_rpmmacrosdir/*

%files -n rpm-macros-%{name}
%_rpmmacrosdir/*


%changelog
