Name: lapack
%define sover 4
%define soname lib%name.so.%sover
Version: 3.5.0
Epoch: 1
Release: alt1

Summary: BLAS and LAPACK Fortran libraries for numerical linear algebra (with GotoBLAS2)
License: BSD
Group: Development/Other

URL: http://www.netlib.org/
Source: %name-%version.tar
Source1: manpages.tar
Source2: zla_rpvgrw.f
Source3: sla_rpvgrw.f
Source4: cla_rpvgrw.f
Source5: dla_rpvgrw.f
Patch: lapack-3.1.1-alt3.qa1.patch
Patch100: lapack-3.4.2-alt2-armh-patch.patch
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

BuildRequires: gcc-fortran cmake
BuildPreReq: libsuperlu-devel

BuildPreReq: libxblas-devel
# for %%check
BuildPreReq: ctest python-modules

%ifarch %arm
BuildRequires: libblas-devel
%else
BuildRequires: libopenblas-devel
%endif

%package -n lib%name
Summary: BLAS and LAPACK Fortran libraries for numerical linear algebra (with GotoBLAS2)
Group: System/Libraries
Conflicts: lib%name-goto < %epoch:%version-%release
Obsoletes: lib%name-goto < %epoch:%version-%release
Obsoletes: liblapack3

%package -n lib%name-devel
Summary: BLAS and LAPACK Fortran libraries for numerical linear algebra (with GotoBLAS2)
Group: Development/Other
%ifarch %arm
Requires: libblas-devel
%else
Requires: libopenblas-devel
%endif
Requires: lib%name = %epoch:%version-%release
Conflicts: lib%name-devel < %epoch:%version-%release
Obsoletes: lib%name-devel < %epoch:%version-%release
Conflicts: lib%name-goto-devel
Obsoletes: lib%name-goto-devel

%package -n blas-man
Summary: BLAS and LAPACK Fortran libraries for numerical linear algebra (with GotoBLAS2)
Group: Development/Documentation
BuildArch: noarch
Conflicts: blas-man < %epoch:%version-%release
Obsoletes: blas-goto-man

%package -n lapack-man
Summary: BLAS and LAPACK Fortran libraries for numerical linear algebra (with GotoBLAS2)
Group: Development/Documentation
Requires: blas-man = %epoch:%version-%release
BuildArch: noarch
Conflicts: lapack-man < %epoch:%version-%release
Obsoletes: lapack-goto-man

%description
LAPACK (Linear Algebra PACKage) is a standard library for numerical
linear algebra. LAPACK provides routines for solving systems of
simultaneous linear equations, least-squares solutions of linear
systems of equations, eigenvalue problems, and singular value
problems. Associated matrix factorizations (LU, Cholesky, QR, SVD,
Schur, and generalized Schur) and related computations (i.e.,
reordering of Schur factorizations and estimating condition numbers)
are also included. LAPACK can handle dense and banded matrices, but
not general sparse matrices. Similar functionality is provided for
real and complex matrices in both single and double precision.

%description -n lib%name
LAPACK (Linear Algebra PACKage) is a standard library for numerical
linear algebra. LAPACK provides routines for solving systems of
simultaneous linear equations, least-squares solutions of linear
systems of equations, eigenvalue problems, and singular value
problems. Associated matrix factorizations (LU, Cholesky, QR, SVD,
Schur, and generalized Schur) and related computations (i.e.,
reordering of Schur factorizations and estimating condition numbers)
are also included. LAPACK can handle dense and banded matrices, but
not general sparse matrices. Similar functionality is provided for
real and complex matrices in both single and double precision.

%description -n lib%name-devel
LAPACK (Linear Algebra PACKage) is a standard library for numerical
linear algebra. LAPACK provides routines for solving systems of
simultaneous linear equations, least-squares solutions of linear
systems of equations, eigenvalue problems, and singular value
problems. Associated matrix factorizations (LU, Cholesky, QR, SVD,
Schur, and generalized Schur) and related computations (i.e.,
reordering of Schur factorizations and estimating condition numbers)
are also included. LAPACK can handle dense and banded matrices, but
not general sparse matrices. Similar functionality is provided for
real and complex matrices in both single and double precision.

%description -n blas-man
LAPACK (Linear Algebra PACKage) is a standard library for numerical
linear algebra. LAPACK provides routines for solving systems of
simultaneous linear equations, least-squares solutions of linear
systems of equations, eigenvalue problems, and singular value
problems. Associated matrix factorizations (LU, Cholesky, QR, SVD,
Schur, and generalized Schur) and related computations (i.e.,
reordering of Schur factorizations and estimating condition numbers)
are also included. LAPACK can handle dense and banded matrices, but
not general sparse matrices. Similar functionality is provided for
real and complex matrices in both single and double precision.

%description -n lapack-man
LAPACK (Linear Algebra PACKage) is a standard library for numerical
linear algebra. LAPACK provides routines for solving systems of
simultaneous linear equations, least-squares solutions of linear
systems of equations, eigenvalue problems, and singular value
problems. Associated matrix factorizations (LU, Cholesky, QR, SVD,
Schur, and generalized Schur) and related computations (i.e.,
reordering of Schur factorizations and estimating condition numbers)
are also included. LAPACK can handle dense and banded matrices, but
not general sparse matrices. Similar functionality is provided for
real and complex matrices in both single and double precision.

%prep
%setup
%patch -p1
%ifarch %arm
%patch100 -p1
%endif

install -m644 %SOURCE2 %SOURCE3 %SOURCE4 %SOURCE5 SRC
tar -xf %SOURCE1

export LC_COLLATE=C
ls manpages/blas/man/manl >blas.manpages
ls manpages/man/manl >lapack.manpages
comm -12 blas.manpages lapack.manpages >dup.manpages
(cd manpages/man/manl; xargs -r rm -v -- ) <dup.manpages || exit 1
rm blas.manpages lapack.manpages dup.manpages
rm -fR BLAS

%build

# for rpm -bc --short-circuit, rebuild test suite with liblapack.a
rm -f TESTING/x*

FLAGS="-g -pipe -Wall -O3 %optflags_shared -pthread"
cmake \
	-DCMAKE_VERBOSE_MAKEFILE:BOOL=ON \
	-DCMAKE_C_FLAGS:STRING="$FLAGS" \
	-DCMAKE_CXX_FLAGS:STRING="$FLAGS" \
	-DCMAKE_Fortran_FLAGS:STRING="$FLAGS" \
	-DCMAKE_INSTALL_PREFIX:PATH=%prefix \
	-DCMAKE_STRIP:FILEPATH="/bin/echo" \
%ifarch %arm
	-DBLAS_goto2_LIBRARY:FILEPATH=%_libdir/libblas.so \
%else
	-DBLAS_goto2_LIBRARY:FILEPATH=%_libdir/libopenblas.so \
%endif
	-DUSEXBLAS:BOOL=ON \
	-DUSE_XBLAS:BOOL=ON \
	-DBUILD_SHARED_LIBS:BOOL=ON \
	-DBUILD_STATIC_LIBS:BOOL=OFF \
	-DSOVER:STRING=%sover \
%ifarch x86_64
	-DLIB_SUFFIX:STRING=64 \
%endif
	.
%make_build

%install
%makeinstall_std

for f in manpages/blas/man/manl/*.l; do
	m=$(basename "$f" .l).3f
	install -pD -m644 $f %buildroot%_man3dir/"$m"
	echo %_man3dir/"$m*"
done >blas-man.files

for f in manpages/man/manl/*.l; do
	m=$(basename "$f" .l).3f
	# some lapack pages miss .TH header
	if grep -qs -i '^[.]TH[[:space:]]' "$f"; then
		install -pD -m644 $f %buildroot%_man3dir/"$m"
	else
		echo ".TH $(echo ${m%%.3f} |sed -e 's/.*/\U&/') 3" >%buildroot%_man3dir/"$m"
		cat "$f" >>%buildroot%_man3dir/"$m"
	fi
	echo %_man3dir/"$m*"
done >lapack-man.files

%check
echo '#!/bin/sh' >lapack_testing
echo './lapack_testing.py -s -d TESTING' \
	>>lapack_testing
chmod +x lapack_testing
ctest --force-new-ctest-process -VV

%files -n lib%name
%define _customdocdir %_docdir/lapack-3.1
%doc LICENSE README
%_libdir/%soname

%files -n lib%name-devel
%_libdir/liblapack.so
%dir %_libdir/cmake
%_libdir/cmake/*
%_pkgconfigdir/*

%files -n blas-man -f blas-man.files
%files -n lapack-man -f lapack-man.files

%changelog
