Name: latex2html
Version: 2012
Release: alt1

Summary: LaTeX to HTML converter
License: GPLv2
Group: Publishing
Url: http://saftsack.fs.uni-bayreuth.de/~latex2ht
BuildArch: noarch

Source: %url/current/%name-%version.tar
Patch0: latex2html-2002-gsfonts.patch
Patch3: latex2html-2002-path.patch
Patch4: latex2html-2002-alt-perl-path.patch
Patch5: latex2html-2002-alt-perl-syntax.patch
Patch6: latex2html-2002-alt-manual-tex.patch
Patch7: latex2html-2002-alt-perlpath.patch
Patch8: latex2html-2002-rh-grayimg.patch
Patch9: latex2html-2002-rh-tabularx.patch

Patch30: latex2html-2012-alt-perl522.patch

Requires: /usr/bin/latex /usr/bin/dvips
Requires: netpbm

# note that gs is required by tetex-dvips
Requires: %_bindir/gs
BuildRequires: %_bindir/gs

BuildRequires(pre): rpm-build-texmf
# Automatically added by buildreq on Thu Mar 27 2008
BuildRequires: netpbm perl-DBM tetex-dvips tetex-latex

%description
Elaborate perl program to convert latex documents to html,
using LaTeX to process images and equations.

%prep
%setup -q
%patch0 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch30 -p1

%build
%define _perl_lib_path %_datadir/%name
%add_findprov_skiplist %_datadir/%name/versions/*.pl

TMP=/tmp ./configure --with-gs=%_bindir/gs \
	--with-texpath=%_datadir/texmf/tex/ \
	--without-mktexlsr \
	--with-perl=%_bindir/perl \
	--prefix=%prefix \
	--libdir=%_datadir/%name \
	--shlibdir=%_datadir/%name \
	#

%make_build

cd ./docs
TEXINPUTS=.:../texinputs: latex manual
TEXINPUTS=.:../texinputs: latex manual
make
bzip2 -9f manual.ps

%install
# custom "make install" so paths are proper in the perl programs

mkdir -p %buildroot%_bindir
install -p -m755 %name pstoimg texexpand %buildroot%_bindir/

mkdir -p %buildroot%_datadir/%name
cp -avRf \
	IndicTeX-HTML L2hos.pm L2hos XyMTeX-HTML cweb2html docs example foilhtml icons makeseg styles texinputs versions \
	cfgcache.pm dot.latex2html-init l2hconf.pm makemap readme.hthtml \
	%buildroot%_datadir/%name/

mkdir -p %buildroot%_datadir/texmf/tex/latex/html
cp -avRf texinputs/* %buildroot%_datadir/texmf/tex/latex/html

# url.sty is part of latex (#10698)
rm %buildroot%_datadir/texmf/tex/latex/html/url.sty

# this russian style is subject to bNOPNYA
rm %buildroot%_datadir/%name/styles/russian.perl

# fix perl path in a few places:
sed -i '1s|/usr/local/bin/|/usr/bin/|' \
	%buildroot%_datadir/%name/cweb2html/cweb2html \
	%buildroot%_datadir/%name/cweb2html/makemake.pl \
	%buildroot%_datadir/%name/makeseg/makeseg

%files
%_bindir/*
%_datadir/%name/
%_datadir/texmf/tex/latex/html
%doc Changes FAQ LICENSE LICENSE.orig README readme.hthtml TODO BUGS INSTALL dot.latex2html-init example docs/manual.ps.bz2

%changelog
