Name: libHX
Version: 3.22
Release: alt0.M80P.1
Summary: General-purpose library for typical low-level operations

Group: System/Libraries
License: LGPLv2 or LGPLv3
URL: http://jengelh.hopto.org/files/libHX/

Source: libHX-%version.tar
Patch: %name-%version-%release.patch

%description
A library for:
- rbtree with key-value pair extension
- deques (double-ended queues) (Stacks (LIFO) / Queues (FIFOs))
- platform independent opendir-style directory access
- platform independent dlopen-style shared library access
- auto-storage strings with direct access
- command line option (argv) parser
- shconfig-style config file parser
- platform independent random number generator with transparent
  /dev/urandom support
- various string, memory and zvec ops

%package devel
Summary: Development files for %name
Group: Development/C

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name

%prep
%setup -q
%patch -p1

%build
%autoreconf
%configure \
	--disable-static
%make_build

%install
%makeinstall
mkdir -p %buildroot/%_lib
for f in %buildroot%_libdir/%name.so; do
        t=$(readlink "$f")
        ln -sf ../../%_lib/"$t" "$f"
done
mv %buildroot%_libdir/%name.so.* %buildroot/%_lib/

%files
/%_lib/%name.so.*

%files devel
%doc doc/api.txt README.txt
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/libHX.pc

%changelog
