Name: libaff
Version: 3.7.4
Release: alt1

Summary: A set of programs for creating and manipulating AFF files

Group: System/Libraries
License: BSD
# afflib.org unavailable, refs dropped by recent commits
Url: http://digitalcorpora.org/downloads/afflib/

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/simsong/AFFLIBv3/archive/%version.tar
Source: %name-%version.tar

# Automatically added by buildreq on Wed Mar 30 2011
BuildRequires: gcc-c++ glibc-devel libcurl-devel libexpat-devel libfuse-devel libncurses-devel libreadline-devel libssl-devel zlib-devel

%description
AFFLIB is an open source library developed by Simson Garfinkel and Basis
Technology that implements the AFF standard. AFFLIB is distributed under
4-clause Berkeley License and may be freely incorporated into both Open
Source and Proprietary software.

In addition to the library, AFFLIB also comes with the AFF Tools,
a set of programs for creating and manipulating AFF files.

%package devel
Summary: Header files for the afflib library
Group: Development/C
Requires: %name = %version-%release

%description devel
AFFLIB is an open source library developed by Simson Garfinkel and Basis
Technology that implements the AFF standard. AFFLIB is distributed under
4-clause Berkeley License and may be freely incorporated into both Open
Source and Proprietary software.

This package contains the header files.

%package -n aff-tools
Summary: AFFLIB tools
Group: File tools
Requires: %name = %version-%release

%description -n aff-tools
AFFLIB is an open source library developed by Simson Garfinkel and Basis
Technology that implements the AFF standard. AFFLIB is distributed under
4-clause Berkeley License and may be freely incorporated into both Open
Source and Proprietary software.

This package contains AFF Tools.

%prep
%setup

%build
mkdir -p m4
%autoreconf

# EWF support has been dropped upstream
%configure \
    --enable-s3=yes \
    --enable-fuse=yes \
    --with-curl=%prefix \
    --enable-qemu=no \
    --disable-static

# Remove rpath from libtool
sed -i 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' libtool
sed -i 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool

# clean unused-direct-shlib-dependencies
sed -i -e 's! -shared ! -Wl,--as-needed\0!g' libtool

%make_build

%install
%makeinstall_std

%files
%_libdir/*.so.*

%files -n aff-tools
%_bindir/affcat
%_bindir/affcompare
%_bindir/affcrypto
%_bindir/affrecover
%_bindir/affsign
%_bindir/affverify
%_bindir/affconvert
%_bindir/affcopy
%_bindir/affix
%_bindir/affuse
%_bindir/affinfo
%_bindir/affsegment
%_bindir/affstats
%_bindir/affxml
%_bindir/affdiskprint
%_man1dir/*
%doc AUTHORS BUGLIST.txt COPYING ChangeLog NEWS README* doc/*

%files devel
%dir %_includedir/afflib/
%_includedir/afflib/*.h
%_libdir/*.so
%_pkgconfigdir/*.pc

%changelog
