%define _name appstream-glib
%define ver_major 0.6
%define api_ver 1.0
%define asb_ver 5

%if "%(rpmvercmp '%{get_version librpm-devel}' '4.13')" >= "0"
%def_enable rpm
%endif

%def_enable stemmer
%def_enable installed_tests

Name: lib%_name
Version: %ver_major.13
Release: alt0.M80P.1

Summary: Library for AppStream metadata
Group: System/Libraries
License: LGPLv2+
Url: http://www.freedesktop.org/wiki/Distributions/AppStream/

Source: http://people.freedesktop.org/~hughsient/%_name/releases/%_name-%version.tar.xz

%define glib_ver 2.46
%define soup_ver 2.52
%define json_glib_ver 1.1.1

Obsoletes: appdata-tools < 0.1.9
Provides: appdata-tools = %version-%release
Provides: %_bindir/appstream-util

BuildRequires: autoconf-archive glib2-devel >= %glib_ver libgtk+3-devel
BuildRequires: libarchive-devel libsoup-devel >= %soup_ver libgdk-pixbuf-devel
BuildRequires: libpango-devel libsqlite3-devel
BuildRequires: gobject-introspection-devel libgdk-pixbuf-gir-devel
BuildRequires: gtk-doc docbook-utils docbook-dtds
BuildRequires: libyaml-devel gcab libgcab-devel gperf libuuid-devel
BuildRequires: libjson-glib-devel >= %json_glib_ver
BuildRequires: librpm-devel
%{?_enable_stemmer:BuildRequires: libstemmer-devel}
%description
This library provides GObjects and helper methods to make it easy to read and
write AppStream metadata. It also provides a simple DOM implementation that
makes it easy to edit nodes and convert to and from the standardized XML
representation.

%package devel
Summary: GLib Libraries and headers for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
GLib headers and libraries for appstream-glib.

%package gir
Summary: GObject introspection data for the %_name library
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the AppStream metadata library.

%package gir-devel
Summary: GObject introspection devel data for the %_name library
Group: Development/Other
BuildArch: noarch
Requires: %name-gir = %version-%release
Requires: %name-devel = %version-%release

%description gir-devel
GObject introspection devel data for the AppStream metadata library.

%package devel-doc
Summary: Development package for %name
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
This package provides development documentation for the AppStream
metadata library.

%package -n libappstream-builder
Summary: A library and tools to build an AppStream database
Group: System/Libraries
Requires: %name = %version-%release

%description -n libappstream-builder
This library provides GObjects and helper methods to make it easy to
build AppStream database.

%package -n libappstream-builder-devel
Summary: Development files for libappstream-bulder
Group: Development/C
Requires: libappstream-builder = %version-%release
Requires: %name-devel = %version-%release

%description -n libappstream-builder-devel
This package provides development files for libappstream-bulder.

%package -n libappstream-builder-gir
Summary: GObject introspection data for the libappstream-bulder library
Group: System/Libraries
Requires: libappstream-builder = %version-%release
Requires: %name-gir = %version-%release

%description -n libappstream-builder-gir
GObject introspection data for the AppStream builder library.

%package -n libappstream-builder-gir-devel
Summary: GObject introspection devel data for the libappstream-bulder library
Group: Development/Other
BuildArch: noarch
Requires: libappstream-builder-gir = %version-%release
Requires: %name-gir-devel = %version-%release
Requires: libappstream-builder-devel = %version-%release

%description -n libappstream-builder-gir-devel
GObject introspection devel data for the AppStream builder library.

%package tests
Summary: Tests for the %_name package
Group: Development/Other
BuildArch: noarch
Requires: %name = %version-%release

%description tests
This package provides tests programs that can be used to verify
the functionality of the installed %_name library.


%prep
%setup -n %_name-%version

%build
%autoreconf
%configure \
        --enable-gtk-doc \
        --disable-static \
        %{subst_enable rpm} \
        %{subst_enable stemmer} \
        %{subst_enable installed_tests}
%make_build

%install
%makeinstall_std

%find_lang %_name

%files -f %_name.lang
%_bindir/appstream-util
%_bindir/appstream-compose
%_libdir/%name.so.*
%_man1dir/appstream-util.1.*
%_man1dir/appstream-compose.1.*
%_datadir/bash-completion/completions/appstream-util
%doc README.md AUTHORS NEWS

%files devel
%_includedir/%name/
%_libdir/%name.so
%_pkgconfigdir/%_name.pc
%_datadir/aclocal/appstream-xml.m4
%_datadir/aclocal/appdata-xml.m4
%_datadir/gettext/its/appdata.its
%_datadir/gettext/its/appdata.loc

%files gir
%_typelibdir/AppStreamGlib-%api_ver.typelib

%files gir-devel
%_girdir/AppStreamGlib-%api_ver.gir

%files devel-doc
%_datadir/gtk-doc/html/%_name/

%files -n libappstream-builder
%_bindir/appstream-builder
%_libdir/libappstream-builder.so.*
%dir %_libdir/asb-plugins-%asb_ver
%_libdir/asb-plugins-%asb_ver/*.so
%_man1dir/appstream-builder.1.*
%_datadir/bash-completion/completions/appstream-builder

%exclude %_libdir/asb-plugins-%asb_ver/*.la

%files -n libappstream-builder-devel
%_libdir/libappstream-builder.so
%_pkgconfigdir/appstream-builder.pc
%_includedir/libappstream-builder/

%files -n libappstream-builder-gir
%_typelibdir/AppStreamBuilder-%api_ver.typelib

%files -n libappstream-builder-gir-devel
%_girdir/AppStreamBuilder-%api_ver.gir

%if_enabled installed_tests
%files tests
%_datadir/installed-tests/%_name/
%endif

#%files -n libappstream-builder-devel-doc
#%_datadir/gtk-doc/html/appstream-builder/

%changelog
