%define _name atk
%define ver_major 2.24
%def_disable static
%def_disable gtk_doc
%def_enable introspection

Name: libatk
Version: %ver_major.0
Release: alt0.M80P.1

Summary: Accessibility features for Gtk+
License: %lgpl2plus
Group: System/Libraries
Url: http://developer.gnome.org/atk

Source: %gnome_ftp/%_name/%ver_major/%_name-%version.tar.xz
Source1: atk-compat.map
Source2: atk-compat.lds
Patch: atk-1.33.6-alt-compat-version-script.patch

Requires: %name-locales = %version

Provides: atk = %version
Obsoletes: atk < %version

%define glib_ver 2.31.2
%define gtk_doc_ver 1.0

BuildPreReq: rpm-build-gnome rpm-build-licenses gnome-common
BuildPreReq: glib2-devel >= %glib_ver
BuildPreReq: gtk-doc >= %gtk_doc_ver
%{?_enable_introspection:BuildRequires: gobject-introspection-devel >= 0.6.7}

%description
Accessibility means providing system infrastructure that allows add-on
assistive software to transparently provide specalized input and ouput
capabilities. For example, screen readers allow blind users to navigate
through applications, determine the state of controls, and read text via
text to speech conversion. On-screen keyboards replace physical
keyboards, and head-mounted pointers replace mice.

ATK, the Accessibility Tookit, is used to obtain accessibily information
from GTK+ and GNOME widgets.

%package locales
Summary: Internationalization for ATK
Group: System/Internationalization
Conflicts: %name < %version-%release
BuildArch: noarch

%description locales
This package provides internationalization support for ATK,
the Accessibility Toolkit.

%package devel
Summary: Development environment for atk
Group: Development/C
Requires: %name = %version-%release
Provides: atk-devel = %version
Obsoletes: atk-devel < %version

%description devel
This package contains the necessary components to develop for ATK,
the Accessibility Toolkit.

%package devel-doc
Summary: Development documentation for ATK
Group: Development/C
BuildArch: noarch
Conflicts: %name < %version-%release

%description devel-doc
ATK, the Accessibility Tookit, is used to obtain accessibily information
from GTK+ and GNOME widgets.

This package contains development documentation for ATK.

%package devel-static
Summary: Stuff for developing with atk
Group: Development/C
Requires: %name-devel = %version-%release
Provides: atk-devel-static = %version
Obsoletes: atk-devel-static < %version

%description devel-static
This package contains the necessary components to develop statically
linked software for atk, the Accessibility Toolkit.

%package gir
Summary: GObject introspection data for the Atk library
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the Atk library

%package gir-devel
Summary: GObject introspection devel data for the Atk library
Group: Development/Other
BuildArch: noarch
Requires: %name-devel = %version-%release
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the Atk library

%prep
%setup -n %_name-%version
%patch -p1
install -p -m644 %_sourcedir/atk-compat.map atk/compat.map
install -p -m644 %_sourcedir/atk-compat.lds atk/compat.lds

%build
%autoreconf
%configure %{subst_enable static} \
	%{?_enable_gtk_doc:--enable-gtk-doc} \
	%{subst_enable introspection}

%make_build

%install
%makeinstall_std

%find_lang --output=%_name.lang %_name %{_name}10

%files
%_libdir/*.so.*
%doc AUTHORS NEWS README

%files locales -f %_name.lang

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*

%files devel-doc
%_datadir/gtk-doc/html/*

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%if_enabled introspection
%files gir
%_typelibdir/*

%files gir-devel
%_girdir/*
%endif

%changelog
