# vim: set ft=spec fdm=marker :

# {{{ Macros
%define set_disable() %{expand:%%force_disable %{1}} %{expand:%%undefine _enable_%{1}}
%define set_enable() %{expand:%%force_enable %{1}} %{expand:%%undefine _disable_%{1}}
%define subst_enable_with() %{expand:%%{?_enable_%{1}:--enable-%{2}} } %{expand:%%{?_disable_%{1}:--disable-%{2}} }
# }}}

# {{{ Enable/Disable stuff
%def_enable gpl
%def_enable version3
%def_enable gnutls
%def_enable libxvid
%def_enable libx264
%def_enable libx265
%def_enable libmp3lame
%def_enable libvorbis
%def_enable libcdio
%def_disable libfaac
%def_enable libfreetype
%def_enable libpulse
%def_disable nonfree
%def_enable libgsm
%def_enable libdc1394
%def_enable shared
%def_enable static
%def_enable pthreads
%def_enable zlib
%ifarch %ix86 x86_64
%def_enable mmx
%else
%def_disable mmx
%endif
%def_disable memalign_hack
%def_enable avplay
%def_enable avprobe
%def_enable libschroedinger
%def_disable avisynth
%def_enable libtheora
%def_disable debug
%def_enable bzlib
%def_enable vaapi
%def_enable vdpau
%def_enable libopencore_amrwb
%def_enable libopencore_amrnb
%def_enable libvpx
%def_enable libv4l2
%def_enable libspeex
%def_enable librtmp
%def_disable frei0r

%if_disabled gpl
%set_disable libxvid
%set_disable libx264
%set_disable libx265
%endif

%if_disabled version3
%set_disable libopencore_amrwb
%set_disable libopencore_amrnb
%endif

%if_disabled nonfree
%set_disable libfaac
%endif

%if_enabled mmx
%set_verify_elf_method textrel=relaxed
%endif
%ifarch %arm
%set_verify_elf_method textrel=relaxed
%endif
# }}}

Name: libav
Version: 11.6
Release: alt1
Epoch: 1

Summary: Hyper fast MPEG1/MPEG4/H263/RV and AC3/MPEG audio encoder
License: %{!?_enable_gpl:L}GPL%{?_enable_version3:3}
Group: System/Libraries
Url: http://libav.org

Source0: %name-%version-%release.tar

# {{{ BuildRequires
BuildRequires: libfreetype-devel texi2html
BuildRequires: libX11-devel libXext-devel libXvMC-devel libXfixes-devel
BuildRequires: yasm
BuildRequires: libalsa-devel
BuildRequires: perl-podlators

%{?_enable_avplay:BuildRequires: libSDL-devel}
%{?_enable_gnutls:BuildRequires: libgnutls-devel}
%{?_enable_libmp3lame:BuildRequires: liblame-devel}
%{?_enable_libvorbis:BuildRequires: libvorbis-devel}
%{?_enable_libfaac:BuildRequires: libfaac-devel}
%{?_enable_libcdio:BuildRequires: libcdio-devel libcdio-paranoia-devel}
%{?_enable_libgsm:BuildRequires: libgsm-devel}
%{?_enable_libpulse:BuildRequires: libpulseaudio-devel}
%{?_enable_libxvid:BuildRequires: libxvid-devel}
%{?_enable_libx264:BuildRequires: libx264-devel >= 118}
%{?_enable_libx265:BuildRequires: libx265-devel}
%{?_enable_libdc1394:BuildRequires: libdc1394-devel libraw1394-devel}
%{?_enable_libschroedinger:BuildRequires: libschroedinger-devel}
%{?_enable_libtheora:BuildRequires: libtheora-devel}
%{?_enable_bzlib:BuildRequires: bzlib-devel}
%{?_enable_vaapi:BuildRequires: libva-devel}
%{?_enable_vdpau:BuildRequires: libvdpau-devel}
%{?_enable_libopencore_amrwb:BuildRequires: libopencore-amrwb-devel}
%{?_enable_libopencore_amrnb:BuildRequires: libopencore-amrnb-devel}
%{?_enable_libvpx:BuildRequires: libvpx-devel}
%{?_enable_libv4l2:BuildRequires: libv4l-devel}
%{?_enable_librtmp:BuildRequires: librtmp-devel}
%{?_enable_frei0r:BuildRequires: frei0r-devel}
%{?_enable_libspeex:BuildRequires: libspeex-devel}
# }}}

# {{{ Packages
%package doc
Summary: Documentation files for libav project.
Group: Video
BuildArch: noarch
Provides: ffmpeg-doc = %epoch:%version-%release
Obsoletes: ffmpeg-doc

%package -n avplay
Summary: A very simple media player using the libav and SDL libraries
Group: Video
Requires: libavcodec56 = %epoch:%version-%release
Requires: libavformat56 = %epoch:%version-%release
Provides: ffplay = %epoch:%version-%release
Obsoletes: ffplay

%package -n avprobe
Summary:  Multimedia streams analyzer
Group: Video
Requires: libavcodec56 = %epoch:%version-%release
Requires: libavformat56 = %epoch:%version-%release
Provides: ffprobe = %epoch:%version-%release
Obsoletes: ffprobe

%package -n avconv
Summary: Hyper fast MPEG1/MPEG4/H263/RV and AC3/MPEG audio encoder
Group: Video
Requires: libavcodec56 = %epoch:%version-%release
Requires: libavformat56 = %epoch:%version-%release
Requires: libavutil54 = %epoch:%version-%release
Requires: libavdevice55 = %epoch:%version-%release
Requires: libavfilter5 = %epoch:%version-%release
Provides: ffmpeg = %epoch:%version-%release
Obsoletes: ffmpeg

%package -n libavcodec56
Summary: libav codec library
Group: System/Libraries
Provides: libavcodec = %epoch:%version-%release
Obsoletes: libavcodec < %epoch:%version-%release

%package -n libavcodec-devel
Summary: Development files for libavcodec
Group: Development/C
Requires: libavcodec56 = %epoch:%version-%release
Requires: libavutil-devel = %epoch:%version-%release

%package -n libavcodec-devel-static
Summary: Static development files for libavcodec
Group: Development/C
Requires: libavcodec-devel = %epoch:%version-%release

%package -n libavformat56
Summary: libav file format library
Group: System/Libraries
Requires: libavcodec56 = %epoch:%version-%release
Provides: libavformat = %epoch:%version-%release
Obsoletes: libavformat < %epoch:%version-%release

%package -n libavformat-devel
Summary: Development files for libavcodec
Group: Development/C
Requires: libavformat56 = %epoch:%version-%release
Requires: libavcodec-devel = %epoch:%version-%release

%package -n libavformat-devel-static
Summary: Static development files for libavformat
Group: Development/C
Requires: libavformat-devel = %epoch:%version-%release

%package -n libavutil54
Summary: libav utility library
Group: System/Libraries
Provides: libavutil = %epoch:%version-%release

%package -n libavutil-devel
Summary: Development files for libavutil
Group: Development/C
Requires: libavutil54 = %epoch:%version-%release

%package -n libavutil-devel-static
Summary: Static development files for libavutil
Group: Development/C
Requires: libavutil-devel = %epoch:%version-%release

%package -n libavresample2
Summary: libav video postprocessing library
Group: System/Libraries

%package -n libavresample-devel
Summary: Development files for libavresample
Group: Development/C
Requires: libavresample2 = %epoch:%version-%release
Requires: libavutil-devel = %epoch:%version-%release

%package -n libavresample-devel-static
Summary: Static development files for libavresample
Group: Development/C
Requires: libavresample-devel = %epoch:%version-%release

%package -n libswscale3
Summary: libav image rescaling library
Group: System/Libraries

%package -n libswscale-devel
Summary: Development files for libswscale
Group: Development/C
Requires: libswscale3 = %epoch:%version-%release
Requires: libavutil-devel = %epoch:%version-%release

%package -n libswscale-devel-static
Summary: Static development files for libswscale
Group: Development/C
Requires: libswscale-devel = %epoch:%version-%release

%package -n libavdevice55
Summary: libav device handling library
Group: System/Libraries

%package -n libavdevice-devel
Summary: Development files for libavdevice
Group: Development/C
Requires: libavdevice55 = %epoch:%version-%release

%package -n libavdevice-devel-static
Summary: Static development files for libavdevice
Group: Development/C
Requires: libavdevice-devel = %epoch:%version-%release

%package -n libavfilter5
Summary: libav filter handling library
Group: System/Libraries

%package -n libavfilter-devel
Summary: Development files for libavfilter
Group: Development/C
Requires: libavfilter5 = %epoch:%version-%release

%package -n libavfilter-devel-static
Summary: Static development files for libavfilter
Group: Development/C
Requires: libavfilter-devel = %epoch:%version-%release

# }}}

# {{{ Descriptions

%description
%name is a hyper fast realtime audio/video encoder, a streaming
server and a generic audio and video file converter.

It can grab from a standard Video4Linux video source and convert it
into several file formats based on DCT/motion compensation encoding.
Sound is compressed in MPEG audio layer 2 or using an AC3 compatible
stream.

%description doc
This package contains documentation for libav project.

%description -n avplay
avplay is a very simple and portable media player using the libav
libraries and the SDL library. It is mostly used as a testbed for the
various libav APIs

%description -n avprobe
avprobe is a simple multimedia streams analyzer with a command-line
interface based on the libav project libraries.

%description -n avconv
avconv is a hyper fast realtime audio/video encoder, a streaming
server and a generic audio and video file converter.

It can grab from a standard Video4Linux video source and convert it
into several file formats based on DCT/motion compensation encoding.
Sound is compressed in MPEG audio layer 2 or using an AC3 compatible
stream.

%description -n libavcodec56
This package contains libavcodec, the libav project codec library.

%description -n libavcodec-devel
This package contains development files for libavcodec.

%description -n libavformat56
This package contains libavformat, the libav project file format library.

%description -n libavformat-devel
This package contains development files for libavformat.

%description -n libavutil54
This package contains libavutil, the libav project utility library.

%description -n libavutil-devel
This package contains development files for libavutil.

%description -n libavresample2
This package contains libavresample, the libav project video postprocessing library.

%description -n libavresample-devel
This package contains development files for libpostproc

%description -n libswscale3
This package contains libswscale, the libav project image rescaling library.

%description -n libswscale-devel
This package contains development files for libswscale.

%description -n libavdevice55
This package contains libavdevice, the libav project device handling library.

%description -n libavdevice-devel
This package contains development files for libavdevice.

%description -n libavfilter5
This package contains libavfilter, the libav project filter handling library.

%description -n libavfilter-devel
This package contains development files for libavfilter.

%description -n libavformat-devel-static
This package contains static development files for libavformat.

%description -n libavcodec-devel-static
This package contains static development files for libavcodec.

%description -n libavresample-devel-static
This package contains static development files for libavresample

%description -n libswscale-devel-static
This package contains static development files for libswscale

%description -n libavutil-devel-static
This package contains static development files for libavutil.

%description -n libavdevice-devel-static
This package contains static development files for libavdevice.

%description -n libavfilter-devel-static
This package contains static development files for libavfilter.

# }}}

# {{{ Prep
%prep
%setup
sed -i 's/UNKNOWN/%version/' version.sh
# }}}

# {{{ Build
%build
%add_optflags -frename-registers
%ifarch x86_64
%add_optflags %optflags_shared
%else
%ifarch %ix86
%add_optflags %{?_enable_mmx:-DRUNTIME_CPUDETECT}
%endif
%endif
./configure \
    --prefix=%_prefix \
    --libdir=%_libdir \
    --shlibdir=%_libdir \
    --mandir=%_mandir \
    %{subst_enable gpl} \
    %{subst_enable pthreads} \
    %{subst_enable shared} \
    %{subst_enable static} \
    %{subst_enable gnutls} \
    %{subst_enable libvorbis} \
    %{subst_enable libfaac} \
    %{subst_enable libfreetype} \
    %{subst_enable libpulse} \
    %{subst_enable libxvid} \
    %{subst_enable libx264} \
    %{subst_enable libx265} \
    %{subst_enable libmp3lame} \
    %{subst_enable libcdio} \
    %{subst_enable libgsm} \
    %{subst_enable libdc1394} \
    %{subst_enable zlib} \
    %{subst_enable mmx} \
    %{subst_enable_with memalign_hack memalign-hack} \
    %{subst_enable avplay} \
    %{subst_enable avprobe} \
    %{subst_enable libschroedinger} \
    --enable-avfilter \
    %{subst_enable avisynth} \
    %{subst_enable libtheora} \
    %{subst_enable version3} \
    %{subst_enable_with libopencore_amrwb libopencore-amrwb} \
    %{subst_enable_with libopencore_amrnb libopencore-amrnb} \
    --enable-hardcoded-tables \
    --enable-runtime-cpudetect \
    --enable-x11grab \
    --enable-bzlib \
    %{subst_enable libvpx} \
    %{subst_enable libv4l2} \
    %{subst_enable libspeex} \
    %{subst_enable frei0r} \
    %{subst_enable nonfree} \
    %{subst_enable librtmp} \
    %{subst_enable vaapi} \
    %{subst_enable vdpau} \
%if_enabled debug
    --enable-debug \
    --disable-stripping \
%else
    --disable-debug \
%endif
    --enable-pic \
    --extra-cflags="%optflags" \
    --extra-version='%release'

%make_build

# }}}

# {{{ Install
%install
%make_install \
		INCDIR="%buildroot%_includedir" \
		DESTDIR="%buildroot" \
		MANDIR="%buildroot%_mandir" install

bzip2 --best --force --keep -- Changelog

# }}}

# {{{ Files

%files doc
%doc doc/developer.html
%doc doc/faq.html
%doc doc/fate.html
%doc doc/general.html
%doc doc/git-howto.html
%doc doc/libavfilter.html
%doc doc/nut.html
%doc doc/platform.html
%doc doc/optimization.txt
%doc CREDITS
%doc Changelog.*

%files -n libavcodec56
%_libdir/libavcodec.so.*

%files -n libavcodec-devel
%_includedir/libavcodec
%_libdir/libavcodec.so
%_pkgconfigdir/libavcodec.pc

%files -n libavformat56
%_libdir/libavformat.so.*

%files -n libavformat-devel
%_includedir/libavformat
%_pkgconfigdir/libavformat.pc
%_libdir/libavformat.so

%files -n libavutil54
%_libdir/libavutil.so.*

%files -n libavutil-devel
%_includedir/libavutil
%_libdir/libavutil.so
%_pkgconfigdir/libavutil.pc

%files -n libavdevice55
%_libdir/libavdevice.so.*

%files -n libavdevice-devel
%_includedir/libavdevice
%_libdir/libavdevice.so
%_pkgconfigdir/libavdevice.pc

%files -n libavfilter5
%_libdir/libavfilter.so.*

%files -n libavfilter-devel
%_includedir/libavfilter
%_libdir/libavfilter.so
%_pkgconfigdir/libavfilter.pc

%files -n libavresample2
%_libdir/libavresample.so.*

%files -n libavresample-devel
%_pkgconfigdir/libavresample.pc
%_includedir/libavresample
%_libdir/libavresample.so

%files -n libswscale3
%_libdir/libswscale.so.*

%files -n libswscale-devel
%_includedir/libswscale
%_pkgconfigdir/libswscale.pc
%_libdir/libswscale.so

%if_enabled static
%files -n libavformat-devel-static
%_libdir/libavformat.a

%files -n libavcodec-devel-static
%_libdir/libavcodec.a

%files -n libavutil-devel-static
%_libdir/libavutil.a

%files -n libavresample-devel-static
%_libdir/libavresample.a

%files -n libswscale-devel-static
%_libdir/libswscale.a

%files -n libavdevice-devel-static
%_libdir/libavdevice.a

%files -n libavfilter-devel-static
%_libdir/libavfilter.a
%endif

%files -n avconv
%doc doc/avconv.html
%_bindir/avconv
%_man1dir/avconv.*
%_datadir/avconv

%if_enabled avplay
%files -n avplay
%doc doc/avplay.html
%_bindir/avplay
%_man1dir/avplay.*
%endif

%if_enabled avprobe
%files -n avprobe
%doc doc/avprobe.html
%_bindir/avprobe
%_man1dir/avprobe.*
%endif

# }}}

# {{{ Changelog
%changelog
