# vim: set ft=spec fdm=marker :

# {{{ Macros
%define set_disable() %{expand:%%force_disable %{1}} %{expand:%%undefine _enable_%{1}}
%define set_enable() %{expand:%%force_enable %{1}} %{expand:%%undefine _disable_%{1}}
%define subst_enable_with() %{expand:%%{?_enable_%{1}:--enable-%{2}} } %{expand:%%{?_disable_%{1}:--disable-%{2}} }
# }}}

# {{{ Enable/Disable stuff
%def_enable gpl
%def_enable version3
%def_enable libxvid
%def_enable libx264
%def_enable postproc
%def_enable libmp3lame
%def_enable libvorbis
%def_enable libcdio
%def_disable libfaac
%def_enable libpulse
%def_disable nonfree
%def_enable libgsm
%def_enable libdc1394
%def_enable shared
%def_disable static
%def_enable pthreads
%def_enable zlib
%ifarch %ix86 x86_64
%def_enable mmx
%else
%def_disable mmx
%endif
%def_disable iwmmxt
%def_disable memalign_hack
%def_enable avserver
%def_enable avplay
%def_enable avprobe
%def_disable libdirac
%def_enable libschroedinger
%def_disable avisynth
%def_disable libnut
%def_enable libtheora
%def_disable debug
%def_enable bzlib
%ifarch %ix86 x86_64
%def_enable vaapi
%def_enable vdpau
%else
%def_disable vaapi
%def_disable vdpau
%endif
%def_enable libopencore_amrwb
%def_enable libopencore_amrnb
%def_enable libvpx
%def_enable libv4l2
%def_enable libspeex
%def_enable librtmp
%def_disable frei0r

%if_disabled gpl
%set_disable libxvid
%set_disable libx264
%set_disable postproc
%endif

%if_disabled version3
%set_disable libopencore_amrwb
%set_disable libopencore_amrnb
%endif

%if_disabled nonfree
%set_disable libfaac
%endif

%if_enabled mmx
%set_verify_elf_method textrel=relaxed
%endif
%ifarch %arm
%set_verify_elf_method textrel=relaxed
%endif
# }}}

Name: libav0.8
Version: 0.8.11
Release: alt1
Epoch: 1

Summary: Hyper fast MPEG1/MPEG4/H263/RV and AC3/MPEG audio encoder
License: %{!?_enable_gpl:L}GPL%{?_enable_version3:3}
Group: System/Libraries
Url: http://libav.org

Source0: %name-%version-%release.tar

# {{{ BuildRequires
BuildRequires: libfreetype-devel texi2html
BuildRequires: libX11-devel libXext-devel libXvMC-devel libXfixes-devel
BuildRequires: yasm
BuildRequires: libalsa-devel
BuildRequires: perl-podlators

%{?_enable_avplay:BuildRequires: libSDL-devel}
%{?_enable_libmp3lame:BuildRequires: liblame-devel}
%{?_enable_libvorbis:BuildRequires: libvorbis-devel}
%{?_enable_libfaac:BuildRequires: libfaac-devel}
%{?_enable_libcdio:BuildRequires: libcdio-devel}
%{?_enable_libgsm:BuildRequires: libgsm-devel}
%{?_enable_libpulse:BuildRequires: libpulseaudio-devel}
%{?_enable_libxvid:BuildRequires: libxvid-devel}
%{?_enable_libx264:BuildRequires: libx264-devel >= 118}
%{?_enable_libdc1394:BuildRequires: libdc1394-devel libraw1394-devel}
%{?_enable_libdirac:BuildRequires: libdirac-devel >= 0.9.1-alt1 libstdc++-devel gcc4.1-c++}
%{?_enable_libschroedinger:BuildRequires: libschroedinger-devel}
%{?_enable_libnut:BuildRequires: libnut-devel}
%{?_enable_libtheora:BuildRequires: libtheora-devel}
%{?_enable_bzlib:BuildRequires: bzlib-devel}
%{?_enable_vaapi:BuildRequires: libva-devel}
%{?_enable_vdpau:BuildRequires: libvdpau-devel}
%{?_enable_libopencore_amrwb:BuildRequires: libopencore-amrwb-devel}
%{?_enable_libopencore_amrnb:BuildRequires: libopencore-amrnb-devel}
%{?_enable_libvpx:BuildRequires: libvpx-devel}
%{?_enable_libv4l2:BuildRequires: libv4l-devel}
%{?_enable_librtmp:BuildRequires: librtmp-devel}
%{?_enable_frei0r:BuildRequires: frei0r-devel}
%{?_enable_libspeex:BuildRequires: libspeex-devel}
# }}}

# {{{ Packages
%package doc
Summary: Documentation files for libav project.
Group: Video
BuildArch: noarch
Provides: ffmpeg-doc = %epoch:%version-%release
Obsoletes: ffmpeg-doc

%package -n avserver
Summary: A streaming server for both audio and video
Group: Video
Requires: libavcodec53 = %epoch:%version-%release
Requires: libavformat53 = %epoch:%version-%release
Provides: ffserver = %epoch:%version-%release
Obsoletes: ffserver

%package -n avplay
Summary: A very simple media player using the libav and SDL libraries
Group: Video
Requires: libavcodec53 = %epoch:%version-%release
Requires: libavformat53 = %epoch:%version-%release
Provides: ffplay = %epoch:%version-%release
Obsoletes: ffplay

%package -n avprobe
Summary:  Multimedia streams analyzer
Group: Video
Requires: libavcodec53 = %epoch:%version-%release
Requires: libavformat53 = %epoch:%version-%release
Provides: ffprobe = %epoch:%version-%release
Obsoletes: ffprobe

%package -n avconv
Summary: Hyper fast MPEG1/MPEG4/H263/RV and AC3/MPEG audio encoder
Group: Video
Requires: libavcodec53 = %epoch:%version-%release
Requires: libavformat53 = %epoch:%version-%release
Requires: libavutil51 = %epoch:%version-%release
Requires: libavdevice = %epoch:%version-%release
Requires: libavfilter = %epoch:%version-%release
Provides: ffmpeg = %epoch:%version-%release
Obsoletes: ffmpeg

%package -n libavcodec53
Summary: libav codec library
Group: System/Libraries
Provides: libavcodec = %epoch:%version-%release
Obsoletes: libavcodec < %epoch:%version-%release
%{?_enable_libdirac:Requires: libdirac >= 0.9.1-alt1}

%package -n libavcodec-devel
Summary: Development files for libavcodec
Group: Development/C
Requires: libavcodec53 = %epoch:%version-%release
Requires: libavutil-devel = %epoch:%version-%release

%package -n libavcodec-devel-static
Summary: Static development files for libavcodec
Group: Development/C
Requires: libavcodec-devel = %epoch:%version-%release

%package -n libavformat53
Summary: libav file format library
Group: System/Libraries
Requires: libavcodec53 = %epoch:%version-%release
Provides: libavformat = %epoch:%version-%release
Obsoletes: libavformat < %epoch:%version-%release

%package -n libavformat-devel
Summary: Development files for libavcodec
Group: Development/C
Requires: libavformat53 = %epoch:%version-%release
Requires: libavcodec-devel = %epoch:%version-%release

%package -n libavformat-devel-static
Summary: Static development files for libavformat
Group: Development/C
Requires: libavformat-devel = %epoch:%version-%release

%package -n libavutil51
Summary: libav utility library
Group: System/Libraries
Provides: libavutil = %epoch:%version-%release

%package -n libavutil-devel
Summary: Development files for libavutil
Group: Development/C
Requires: libavutil51 = %epoch:%version-%release

%package -n libavutil-devel-static
Summary: Static development files for libavutil
Group: Development/C
Requires: libavutil-devel = %epoch:%version-%release

%package -n libpostproc
Summary: libav video postprocessing library
Group: System/Libraries

%package -n libpostproc-devel
Summary: Development files for libpostproc
Group: Development/C
Requires: libpostproc = %epoch:%version-%release
Requires: libavutil-devel = %epoch:%version-%release

%package -n libpostproc-devel-static
Summary: Static development files for libpostproc
Group: Development/C
Requires: libpostproc-devel = %epoch:%version-%release

%package -n libswscale
Summary: libav image rescaling library
Group: System/Libraries

%package -n libswscale-devel
Summary: Development files for libswscale
Group: Development/C
Requires: libswscale = %epoch:%version-%release
Requires: libavutil-devel = %epoch:%version-%release

%package -n libswscale-devel-static
Summary: Static development files for libswscale
Group: Development/C
Requires: libswscale-devel = %epoch:%version-%release

%package -n libavdevice
Summary: libav device handling library
Group: System/Libraries

%package -n libavdevice-devel
Summary: Development files for libavdevice
Group: Development/C
Requires: libavdevice = %epoch:%version-%release

%package -n libavdevice-devel-static
Summary: Static development files for libavdevice
Group: Development/C
Requires: libavdevice-devel = %epoch:%version-%release

%package -n libavfilter
Summary: libav filter handling library
Group: System/Libraries

%package -n libavfilter-devel
Summary: Development files for libavfilter
Group: Development/C
Requires: libavfilter = %epoch:%version-%release

%package -n libavfilter-devel-static
Summary: Static development files for libavfilter
Group: Development/C
Requires: libavfilter-devel = %epoch:%version-%release

# }}}

# {{{ Descriptions

%description
%name is a hyper fast realtime audio/video encoder, a streaming
server and a generic audio and video file converter.

It can grab from a standard Video4Linux video source and convert it
into several file formats based on DCT/motion compensation encoding.
Sound is compressed in MPEG audio layer 2 or using an AC3 compatible
stream.

%description doc
This package contains documentation for libav project.

%description -n avserver
avserver is a streaming server for both audio and video. It supports
several live feeds, streaming from files and time shifting on live
feeds.

%description -n avplay
avplay is a very simple and portable media player using the libav
libraries and the SDL library. It is mostly used as a testbed for the
various libav APIs

%description -n avprobe
avprobe is a simple multimedia streams analyzer with a command-line
interface based on the libav project libraries.

%description -n avconv
avconv is a hyper fast realtime audio/video encoder, a streaming
server and a generic audio and video file converter.

It can grab from a standard Video4Linux video source and convert it
into several file formats based on DCT/motion compensation encoding.
Sound is compressed in MPEG audio layer 2 or using an AC3 compatible
stream.

%description -n libavcodec53
This package contains libavcodec, the libav project codec library.

%description -n libavcodec-devel
This package contains development files for libavcodec.

%description -n libavformat53
This package contains libavformat, the libav project file format library.

%description -n libavformat-devel
This package contains development files for libavformat.

%description -n libavutil51
This package contains libavutil, the libav project utility library.

%description -n libavutil-devel
This package contains development files for libavutil.

%description -n libpostproc
This package contains libpostproc, the libav project video postprocessing library.

%description -n libpostproc-devel
This package contains development files for libpostproc

%description -n libswscale
This package contains libswscale, the libav project image rescaling library.

%description -n libswscale-devel
This package contains development files for libswscale.

%description -n libavdevice
This package contains libavdevice, the libav project device handling library.

%description -n libavdevice-devel
This package contains development files for libavdevice.

%description -n libavfilter
This package contains libavfilter, the libav project filter handling library.

%description -n libavfilter-devel
This package contains development files for libavfilter.

%description -n libavformat-devel-static
This package contains static development files for libavformat.

%description -n libavcodec-devel-static
This package contains static development files for libavcodec.

%description -n libpostproc-devel-static
This package contains static development files for libpostproc

%description -n libswscale-devel-static
This package contains static development files for libswscale

%description -n libavutil-devel-static
This package contains static development files for libavutil.

%description -n libavdevice-devel-static
This package contains static development files for libavdevice.

%description -n libavfilter-devel-static
This package contains static development files for libavfilter.

# }}}

# {{{ Prep
%prep
%setup
sed -i 's/UNKNOWN/%version/' version.sh
# }}}

# {{{ Build
%build
%add_optflags -frename-registers
%ifarch x86_64
%add_optflags %optflags_shared
%else
%ifarch %ix86
%add_optflags %{?_enable_mmx:-DRUNTIME_CPUDETECT}
%endif
%endif
./configure \
    --prefix=%_prefix \
    --libdir=%_libdir \
    --shlibdir=%_libdir \
    --mandir=%_mandir \
    %{subst_enable gpl} \
    %{subst_enable postproc} \
    %{subst_enable pthreads} \
    %{subst_enable shared} \
    %{subst_enable static} \
    %{subst_enable libvorbis} \
    %{subst_enable libfaac} \
    %{subst_enable libpulse} \
    %{subst_enable libxvid} \
    %{subst_enable libx264} \
    %{subst_enable libmp3lame} \
    %{subst_enable libcdio} \
    %{subst_enable libgsm} \
    %{subst_enable libdc1394} \
    %{subst_enable zlib} \
    %{subst_enable mmx} \
    %{subst_enable iwmmxt} \
    %{subst_enable_with memalign_hack memalign-hack} \
    %{subst_enable avserver} \
    %{subst_enable avplay} \
    %{subst_enable avprobe} \
    %{subst_enable libdirac} \
    %{subst_enable libschroedinger} \
    --enable-avfilter \
    %{subst_enable avisynth} \
    %{subst_enable libnut} \
    %{subst_enable libtheora} \
    %{subst_enable version3} \
    %{subst_enable_with libopencore_amrwb libopencore-amrwb} \
    %{subst_enable_with libopencore_amrnb libopencore-amrnb} \
    --enable-hardcoded-tables \
    --enable-runtime-cpudetect \
    --enable-x11grab \
    --enable-bzlib \
    %{subst_enable libvpx} \
    %{subst_enable libv4l2} \
    %{subst_enable libspeex} \
    %{subst_enable frei0r} \
    %{subst_enable nonfree} \
    %{subst_enable librtmp} \
    %{subst_enable vaapi} \
    %{subst_enable vdpau} \
%if_enabled debug
    --enable-debug \
    --disable-stripping \
%else
    --disable-debug \
%endif
    --enable-pic \
    --extra-cflags="%optflags" \
    --extra-version='%release'

%make

# }}}

# {{{ Install
%install
%make_install \
		INCDIR="%buildroot%_includedir" \
		DESTDIR="%buildroot" \
		MANDIR="%buildroot%_mandir" install

%{?_enable_avserver:install -pD -m640 doc/avserver.conf %buildroot%_sysconfdir/avserver.conf}

%if_enabled postproc
install -d -m 0755 %buildroot%_includedir/postproc
for f in %buildroot%_includedir/libpostproc/*; do
    ln -sf ../libpostproc/$(basename "$f") %buildroot%_includedir/postproc/
done
%endif

bzip2 --best --force --keep -- Changelog

# }}}

# {{{ Files

%if 0
%files doc
%doc doc/faq.html doc/avconv.html doc/ffmpeg.html
%doc doc/optimization.txt
%doc CREDITS
%doc Changelog.*
%endif

%files -n libavcodec53
%_libdir/libavcodec.so.*

%if 0
%files -n libavcodec-devel
%_includedir/libavcodec
%_libdir/libavcodec.so
%_pkgconfigdir/libavcodec.pc
%endif

%files -n libavformat53
%_libdir/libavformat.so.*

%if 0
%files -n libavformat-devel
%_includedir/libavformat
%_pkgconfigdir/libavformat.pc
%_libdir/libavformat.so
%endif

%files -n libavutil51
%_libdir/libavutil.so.*

%if 0
%files -n libavutil-devel
%_includedir/libavutil
%_libdir/libavutil.so
%_pkgconfigdir/libavutil.pc

%files -n libavdevice
%_libdir/libavdevice.so.*

%files -n libavdevice-devel
%_includedir/libavdevice
%_libdir/libavdevice.so
%_pkgconfigdir/libavdevice.pc
%endif

%files -n libavfilter
%_libdir/libavfilter.so.*

%if 0
%files -n libavfilter-devel
%_includedir/libavfilter
%_libdir/libavfilter.so
%_pkgconfigdir/libavfilter.pc

%files -n libpostproc
%_libdir/libpostproc.so.*

%files -n libpostproc-devel
%_pkgconfigdir/libpostproc.pc
%_includedir/postproc
%_includedir/libpostproc
%_libdir/libpostproc.so

%files -n libswscale
%_libdir/libswscale.so.*

%files -n libswscale-devel
%_includedir/libswscale
%_pkgconfigdir/libswscale.pc
%_libdir/libswscale.so
%endif

%if_enabled static
%files -n libavformat-devel-static
%_libdir/libavformat.a

%files -n libavcodec-devel-static
%_libdir/libavcodec.a

%files -n libavutil-devel-static
%_libdir/libavutil.a

%files -n libpostproc-devel-static
%_libdir/libpostproc.a

%files -n libswscale-devel-static
%_libdir/libswscale.a

%files -n libavdevice-devel-static
%_libdir/libavdevice.a

%files -n libavfilter-devel-static
%_libdir/libavfilter.a
%endif

%if 0
%files -n avconv
%_bindir/avconv
%_bindir/ffmpeg
%_man1dir/avconv.*
%_man1dir/ffmpeg.*
%_datadir/avconv

%if_enabled avserver
%files -n avserver
%doc doc/avserver.html
%config(noreplace) %_sysconfdir/*
%_bindir/avserver
%_man1dir/avserver.*
%endif

%if_enabled avplay
%files -n avplay
%doc doc/avplay.html
%_bindir/avplay
%_man1dir/avplay.*
%endif

%if_enabled avprobe
%files -n avprobe
%doc doc/avprobe.html
%_bindir/avprobe
%_man1dir/avprobe.*
%endif
%endif

# }}}

# {{{ Changelog
%changelog
