%define ver_major 2.32
%def_disable static
%def_disable gtk_doc

Name: libbonobo
Version: %ver_major.1
Release: alt4

Summary: Bonobo component system
License: LGPL
Group: System/Libraries
Url: ftp://ftp.gnome.org
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.bz2

Patch: %name-2.3.2-alt-tests_makefile.patch
Patch1: %name-2.13-fix-link-as-needed.patch
Patch2: %name-2.20.0-alt-linking.patch
Patch3: %name-2.32.1-alt-link.patch
Patch4: %name-2.32.1-alt-allow-deprecated.patch
Patch5: %name-2.32.1-alt-makefile.patch

Obsoletes: bonobo-activation
Obsoletes: libbonobo-activation
Obsoletes: libbonobo2 < 2.15.0
Provides: bonobo-activation = %version-%release
Provides: libbonobo-activation = %version-%release
Provides: libbonobo2 = %version-%release

# From configure.in
%define ORBit_ver 2.11.2
%define glib_ver 2.25.7
%define popt_ver 1.5
%define libxml2_ver 2.4.20
%define intltool_ver 0.35
%define gtk_doc_ver 1.0

BuildPreReq: gnome-common
BuildPreReq: rpm-build-gnome
BuildPreReq: intltool >= %intltool_ver
BuildPreReq: ORBit2-devel >= %ORBit_ver
BuildPreReq: libgio-devel >= %glib_ver
BuildPreReq: libpopt-devel >= %popt_ver
BuildPreReq: libxml2-devel >= %libxml2_ver
BuildPreReq: gtk-doc >= %gtk_doc_ver
BuildRequires: flex

# for check
BuildRequires: dbus-tools-gui

%description
Bonobo is a component system based on CORBA, used by the GNOME desktop.

%package devel
Summary: Libraries and headers for libbonobo
Group: Development/GNOME and GTK+
License: GPL/LGPL
Requires: libbonobo = %version-%release
Obsoletes: bonobo-activation-devel
Obsoletes: libbonobo2-devel < 2.15.0
Provides: bonobo-activation-devel = %version-%release
Provides: libbonobo2-devel = %version-%release
Conflicts: bonobo-devel < 1.0.8

%description devel
Bonobo is a component system based on CORBA, used by the GNOME desktop.
This package contains header files used to compile programs that
use Bonobo.

%package devel-doc
Summary: Development documentation for Bonobo
Group: Development/GNOME and GTK+
Obsoletes: libbonobo2-devel-doc < 2.15.0
Provides: libbonobo2-devel-doc = %version-%release
Conflicts: %name < %version-%release
BuildArch: noarch

%description devel-doc
Bonobo is a component system based on CORBA, used by the GNOME desktop.
This package contains development documentation for Bonobo.

%define _gtk_docdir %_datadir/gtk-doc/html
%define _libexecdir %_bindir

%prep
%setup -q

%patch -p1
%patch1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1

%__subst 's,\${prefix}/lib,%_libdir,;s,\${prefix}/etc,%_sysconfdir,' \
    activation-server/bonobo-activation-server.1

rm -f samples/echo/Bonobo_Sample_Echo{-{common,skels,stubs}.c,.h}

%build
%autoreconf

%configure \
	%{subst_enable static} \
	%{?_enable_gtk_doc:--enable-gtk-doc}

# SMP-incompatible build
%make

%check
#%%make check

%install
%make_install DESTDIR=%buildroot install

%find_lang %name-2.0

%files -f %name-2.0.lang
%_bindir/bonobo-activation-server
%_bindir/activation-client
%_bindir/bonobo-slay
%_sbindir/bonobo-activation-sysconf
%_libdir/*.so.*
%dir %_libdir/bonobo
%dir %_libdir/bonobo/servers
%_libdir/bonobo/servers/*
%exclude %_libdir/bonobo/servers/Bonobo_Sample_Echo.server
%dir %_libdir/bonobo/monikers
%_libdir/bonobo/monikers/*.so
%_libdir/orbit-*/*.so
%_datadir/idl/*
%dir %_sysconfdir/bonobo-activation
%config %_sysconfdir/bonobo-activation/*
%_man1dir/*
%doc AUTHORS ChangeLog NEWS README
%exclude %_libdir/bonobo/monikers/*.la
%exclude %_libdir/orbit-*/*.la

%files devel
%_bindir/bonobo-activation-run-query
%_bindir/echo-client-2
%_libdir/bonobo/servers/Bonobo_Sample_Echo.server
%_includedir/*
%_libdir/*.so
%dir %_libdir/bonobo-2.0
%dir %_libdir/bonobo-2.0/samples
%_libdir/bonobo-2.0/samples/*
%_libdir/pkgconfig/*

%files devel-doc
%_gtk_docdir/*

%changelog
