Name: libchewing
Version: 0.4.0
Release: alt1
Summary: Intelligent phonetic input method library for Traditional Chinese

Group: System/Libraries
License: LGPLv2+
Packager: Ilya Mashkin <oddity@altlinux.ru>
Url: http://chewing.csie.net/
Source: http://chewing.csie.net/download/libchewing/%name-%version.tar.gz
Source1:         https://raw.githubusercontent.com/chewing/%{name}/v%{version}/contrib/python/chewing.py


%{!?python_sitearch: %define python_sitearch %(%__python -c "from distutils.sysconfig import get_python_lib; print get_python_lib(1)")}
%define libchewing_python_dir %python_sitearch/%name

BuildRequires: autoconf automake libtool pkgconfig 
BuildRequires:  libsqlite3-devel
Requires: libsqlite3

%description
libchewing is an intelligent phonetic input method library for Chinese.

It provides the core algorithm and logic that can be used by various
input methods.  The Chewing input method is a smart bopomofo phonetics
input method that is useful for inputting Mandarin Chinese.


%package -n %name-devel
Summary: Development files for libchewing
Group: Development/Other
Requires: %name = %version-%release, pkgconfig

%description -n %name-devel
Headers and other files needed to develop applications using the %name
library.


%package -n  python-module-chewing
Summary: libchewing python binding
Group: Development/Other
BuildRequires: python-devel
Requires: %name = %version-%release
Requires: python

%description -n  python-module-chewing
Python binding of libchewing.


%prep
%setup -q
mkdir -p contrib/python
cp -p %SOURCE1 contrib/python


%build
export CFLAGS=-DLIBINSTDIR='\"%_libdir\" -g'
autoreconf -ivf
%configure --disable-static
%__make RPM_CFLAGS="%optflags" %_smp_mflags

%install

%__make DESTDIR=%buildroot install
%__rm $RPM_BUILD_ROOT%_libdir/libchewing.la
%__mkdir -p $RPM_BUILD_ROOT%libchewing_python_dir
%__cp contrib/python/chewing.py $RPM_BUILD_ROOT%libchewing_python_dir
%__mkdir -p $RPM_BUILD_ROOT%_libdir/chewing
#__cp data/fonetree.dat $RPM_BUILD_ROOT%_libdir/chewing
touch $RPM_BUILD_ROOT%libchewing_python_dir/__init__.py


%files
%doc AUTHORS COPYING
%dir %_datadir/libchewing
%_datadir/libchewing/*
%_libdir/*.so.*
%_libdir/chewing

%files devel
%dir %_includedir/chewing
%_includedir/chewing/*
%_libdir/pkgconfig/chewing.pc
%_libdir/*.so

%files -n python-module-chewing
%libchewing_python_dir

%changelog
