%define develname libdbi-devel
Summary: Database Independent Abstraction Layer for C
Name: libdbi
Version: 1.0
Release: alt1.cvs20092729.2
License: LGPL
Group: System/Libraries
Url: http://libdbi.sourceforge.net/
Packager: Boris Savelev <boris@altlinux.org>

Source: %name-%version.tar.gz

# Automatically added by buildreq on Mon Feb 09 2009
BuildRequires: docbook-style-dsssl gcc-c++ openjade w3c-markup-validator-libs

%description
libdbi implements a database-independent abstraction layer in C, similar to the
DBI/DBD layer in Perl. Writing one generic set of code, programmers can
leverage the power of multiple databases and multiple simultaneous database
connections by using this framework.

%package -n %develname
Summary: Library and header files for the %name library
Group: Development/C
Requires: %name = %version-%release

%description -n %develname
libdbi implements a database-independent abstraction layer in C, similar to the
DBI/DBD layer in Perl. Writing one generic set of code, programmers can
leverage the power of multiple databases and multiple simultaneous database
connections by using this framework.

This package contains the header files.

%package -n %develname-static
Summary: Statis library for the %name library
Group: Development/C
Requires: %develname = %version-%release

%description -n %develname-static
libdbi implements a database-independent abstraction layer in C, similar to the
DBI/DBD layer in Perl. Writing one generic set of code, programmers can
leverage the power of multiple databases and multiple simultaneous database
connections by using this framework.

This package contains the static library.

%prep
%setup
# touch doc/libdbi-versioning.sgml

%build
%autoreconf
%configure \
	--disable-docs

%make_build

%install
%makeinstall_std

%files
%doc AUTHORS ChangeLog INSTALL README
%_libdir/*.so.*

%files -n %develname
%doc README TODO
# doc/programmers-guide doc/driver-guide doc/*.pdf
%_includedir/dbi
%_libdir/*.so
%_pkgconfigdir/dbi.pc

%files -n %develname-static
%_libdir/*.a

%changelog
