# -*- mode: rpm-spec; coding: utf-8 -*-
%def_disable static

Summary: A C++ bindings for libdbus and libdbus-glib
Name: libdbus-c++
Version: 0.9.0
Release: alt1.1
License: LGPLv2.1
Group: System/Libraries
URL: http://www.freedesktop.org/wiki/Software/dbus-c++
Packager: Evgeny Sinelnikov <sin@altlinux.ru>

Provides: %name-etersoft = %version-%release

Source0: dbus-c++-%version.tar.bz2
# SuSE
Patch1: libdbus-c++-gcc47.patch
Patch2: libdbus-c++-nodocdatetime.patch
Patch3: libdbus-c++-noreturn.patch
Patch4: libdbus-c++-pthread.patch
# ALT
Patch10: libdbus-c++-0.9.0-alt-linking.patch
Patch11: libdbus-c++-0.9.0-alt-is_running.patch
Patch12: libdbus-c++-0.9.0-alt-enable_auth.patch
Patch13: libdbus-c++-0.9.0-alt-enable_anon.patch

# Automatically added by buildreq on Mon Feb 18 2013 (-bi)
# optimized out: elfutils fontconfig fontconfig-devel glib2-devel libatk-devel libatkmm-devel libcairo-devel libcairomm-devel libdbus-c++ libdbus-devel libfreetype-devel libgdk-pixbuf libgdk-pixbuf-devel libgio-devel libglibmm-devel libgtk+2-devel libpango-devel libpangomm-devel libsigc++2-devel libstdc++-devel libsystemd-daemon libwayland-client libwayland-server pkg-config python-base ruby ruby-stdlibs
#BuildRequires: cups-filters doxygen fonts-ttf-dejavu gcc-c++ glibc-devel-static graphviz libdbus-c++-devel libexpat-devel libgtkmm2-devel rpm-build-ruby
BuildRequires: doxygen gcc-c++ glibc-devel libexpat-devel libdbus-devel libgtkmm2-devel

%description
This package contains C++ bindings for libdbus and libdbus-glib, provides
ability to reflect dbus methods and signals into a more natural C++ object system

%package devel
Summary: Development files for libdbus-c++
Group: Development/C++
Requires: %name = %version-%release
Provides: %name-etersoft-devel = %version-%release

%description devel
This package provides development files for libdbus-c++.

%if_enabled static
%package devel-static
Summary: Static version of libdbus-c++
Group: Development/C++
Requires: %name-devel = %version-%release
Provides: %name-etersoft-devel-static = %version-%release
%description devel-static
This package contains static version of libdbus-c++ library.
%endif

%package apidocs
Summary: libdbus-c++ API documentation
Group: Development/C++
%description apidocs
This package contains Doxygen-generated API documentation for libdbus-c++ library

%package examples
Summary: Example programs which make use of libdbus-c++
Group: Development/C++
Requires: %name-devel = %version
%description examples
Example programs which make use of libdbus-c++

%prep
%setup -q -n dbus-c++
%patch1 -p0
%patch2 -p0
%patch3 -p0
%patch4 -p0
#
%patch10 -p0
%patch11 -p1
%patch12 -p1
%patch13 -p1
./bootstrap

%build
%configure \
	   --disable-ecore \
	   --enable-glib \
	   --enable-doxygen-docs \
	   --disable-examples \
	   %{subst_enable static} \
	   #
%make -C src libdbus-c++-1.la
%make_build
rm -rf libdbus-c*%{version}-doc
tar xvfj libdbus-c*%{version}-doc.tar.bz2

%install
%make -C src DESTDIR=%buildroot install-libLTLIBRARIES
%makeinstall
make -C examples clean

%files
%doc AUTHORS
%doc TODO
%_libdir/libdbus*.so.*

%files devel
%_libdir/libdbus*.so
%_includedir/dbus-c++-?
%_pkgconfigdir/dbus-c++*.pc
# Also include tools here
%_bindir/*

%if_enabled static
%files devel-static
%_libdir/libdbus*.a
%endif

%files apidocs
%doc libdbus-c*%{version}-doc/doc/html

%files examples
%doc examples

%changelog
