%define api_ver 3.0

Name: libdmapsharing
Version: 2.9.39
Release: alt0.M80P.1

Summary: A DMAP client and server library
Group: System/Libraries
License: LGPLv2.1+
Url: http://www.flyn.org/projects/libdmapsharing/

Source: http://www.flyn.org/projects/libdmapsharing/%name-%version.tar.gz

BuildRequires: gtk-doc libgdk-pixbuf-devel libsoup-devel >= 2.48
BuildRequires: gst-plugins1.0-devel libavahi-glib-devel zlib-devel
BuildRequires: gobject-introspection-devel vala-tools libsoup-gir-devel
BuildRequires: libgtk+2-devel libgee0.8-devel
#BuildRequires: libcheck-devel

%description
libdmapsharing implements the DMAP protocols. This includes support for
DAAP and DPAP.

%package devel
Summary: Files needed to develop applications using libdmapsharing
Group: Development/C
Requires: %name = %version-%release

%description devel
libdmapsharing implements the DMAP protocols. This includes support for
DAAP and DPAP.  This package provides the libraries, include files, and
other resources needed for developing applications using libdmapsharing.

%package devel-doc
Summary: Development documentation for %name
Group: Development/Documentation
Conflicts: %name < %version-%release
BuildArch: noarch

%description devel-doc
libdmapsharing implements the DMAP protocols. This includes support for
DAAP and DPAP.

This package contains development documentation for the %name library.

%package gir
Summary: GObject introspection data for %name
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the %name.

%package gir-devel
Summary: GObject introspection devel data for %name
Group: Development/Other
BuildArch: noarch
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the %name.

%prep
%setup

%build
%add_optflags %optflags_shared
%configure --disable-static

%make_build

%install
%makeinstall_std

%check
%make check

%files
%_libdir/%name-%api_ver.so.*
%doc AUTHORS ChangeLog README

%files devel
%_libdir/pkgconfig/%name-%api_ver.pc
%_includedir/%name-%api_ver/
%_libdir/%name-%api_ver.so
%_vapidir/%name-%api_ver.vapi

%files devel-doc
%_datadir/gtk-doc/html/%name-%api_ver/

%files gir
%_typelibdir/DMAP-%api_ver.typelib

%files gir-devel
%_girdir/DMAP-%api_ver.gir

%changelog
