Name: libeo
Version: 1.3.1
Release: alt1.qa3
Summary: EO, the Evolving Objects library
License: LGPLv2.1
Url: http://eodev.sourceforge.net
Source: EO-%version.zip
Patch: libeo-1.2.0-alt-glibc-2.16.patch
Group: Development/C++

# Automatically added by buildreq on Mon Sep 05 2011
# optimized out: cmake cmake-modules libstdc++-devel openssh-common python-base python-devel
BuildRequires: boost-devel-headers boost-python-devel ctest doxygen gcc-c++ git-core gnuplot libgomp-devel unzip

%description
EO is a templates-based, ANSI-C++ compliant evolutionary computation
library. It contains classes for almost any kind of evolutionary
computation you might come up to - at least for the ones we could think
of. It is component-based, so that if you don't find the class you need
in it, it is very easy to subclass existing abstract or concrete
classes.

%define sum EO, the Evolving Objects library

%package devel
Group: Development/C++
Summary: Development environment for %sum
Requires: %name = %EVR
%description devel
Development environment for %sum

%package -n python-module-PyEO
Group: Development/Python
Summary: Python bindings for %sum
Requires: %name = %EVR
%description -n python-module-PyEO
Python bindings for %sum

%prep
%setup -q -c
%patch -p2
# Hack openMP test to be less consuming
sed -i 's/)100/)20/g' eo/test/t-openmp.cpp
sed -i '/#include <eoFunctor.h>/a\
#include <cstdlib>
' eo/src/eoFunctorStore.cpp

%build
# TODO dynamic build

cd eo
%add_optflags -fpermissive
%cmake -DCMAKE_BUILD_TYPE=Release -DENABLE_CMAKE_TESTING=1 \
	-DENABLE_PYEO=1

cd BUILD
%make_build VERBOSE=1

%check
cd eo/BUILD
make test

%install
cd eo/BUILD
cmake -DENABLE_PYEO=1 -DLIB_DESTINATION=%_lib -DLIB_SUFFIX=64 -DCMAKE_INSTALL_PREFIX=%buildroot%prefix -P cmake_install.cmake
mkdir -p %buildroot%_libexecdir/eo
install -D lib/libPyEO.so %buildroot%python_sitelibdir/PyEO.so
mv %buildroot%_datadir/eo/[^d]* %buildroot%_libexecdir/eo/
# TODO when building shared, do not move debuginfo
%ifarch x86_64
mv %buildroot%prefix/lib/* %buildroot%_libdir/
%endif

%files
%doc eo/README
%exclude %_libexecdir
%exclude %_libdir/eo

%files devel
%doc %_datadir/eo/doc
%_libdir/*.a
%_libdir/pkgconfig/eo.pc
%_includedir/eo

%files -n python-module-PyEO
%python_sitelibdir/*.so

#files examples
#_libexecdir/eo/examples
#
#files test
#_libexecdir/eo/test

%changelog
