%define _name libevent
Name: %{_name}2
Version: 2.0.22
Release: alt0.M80P.1

Summary: An asynchronous event notification library
Group: System/Libraries
License: BSD-style
Url: http://www.monkey.org/~provos/libevent/

# http://www.monkey.org/~provos/libevent-%version-stable.tar.gz
Source: %name-%version.tar
Source1: Makefile.sample
Source2: README.libevent
# git://git.altlinux.org/gears/l/%name.git
Patch: %_name-%version-%release.patch

%def_disable static
BuildRequires: libssl-devel zlib-devel

%package -n %_name-devel
Summary: Development libevent library, its header files and documentation
Group: Development/C
Requires: %name = %version-%release
Provides: libevent1.4-devel = %version-%release

%package -n %_name-devel-static
Summary: Static libevent library
Group: Development/C
Requires: %name-devel = %version-%release

%description
The libevent API provides a mechanism to execute a callback function
when a specific event occurs on a file descriptor or after a timeout
has been reached.

libevent is meant to replace the asynchronous event loop found in
event driven network servers.  Currently, libevent supports kqueue(2),
select(2) and epoll(4).

%description -n %_name-devel
The libevent API provides a mechanism to execute a callback function
when a specific event occurs on a file descriptor or after a timeout
has been reached.

libevent is meant to replace the asynchronous event loop found in
event driven network servers.  Currently, libevent supports kqueue(2),
select(2) and epoll(4).

This package contains the header files, documentation, examples and
development library for use in developing applications that use the
libevent library.

%description -n %_name-devel-static
The libevent API provides a mechanism to execute a callback function
when a specific event occurs on a file descriptor or after a timeout
has been reached.

libevent is meant to replace the asynchronous event loop found in
event driven network servers.  Currently, libevent supports kqueue(2),
select(2) and epoll(4).

This package contains the static libevent library necessary to build
statically-linkeed libevent-based applications.

%prep
%setup
%patch -p1

%build
%autoreconf
# force epoll and /dev/epoll support
export haveepoll=yes
%configure %{subst_enable static}
%make_build

%install
%makeinstall_std

# Relocate shared libraries from %_libdir/ to /%_lib/.
mkdir -p %buildroot/%_lib
for f in %buildroot%_libdir/*.so; do
	t=$(readlink "$f") || continue
	ln -snf ../../%_lib/"$t" "$f"
done
mv %buildroot%_libdir/*.so.* %buildroot/%_lib/

%define docdir %_docdir/%name-%version
install -pD -m644 %_sourcedir/Makefile.sample \
	%buildroot%docdir/examples/Makefile
install -p -m644 sample/*.c %buildroot%docdir/examples/
install -pm644 %_sourcedir/README.libevent \
	%buildroot%docdir/README

#Install man
mkdir -p %buildroot%_man3dir
install -p -m644 *.3 %buildroot%_man3dir/

%check
make verify

%files
/%_lib/*.so.*
%dir %docdir
%docdir/README

%files -n %_name-devel
%_bindir/event_rpcgen.py
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*
%_man3dir/*
%dir %docdir
%docdir/examples

%if_enabled static
%files -n %_name-devel-static
%_libdir/*.a
%endif

%changelog
