%define _name exo

Name: lib%_name
Version: 0.10.7
Release: alt1.M80P.1

Summary: Extension library to Xfce
Summary (ru_RU.UTF-8): Библиотека расширений Xfce
License: %lgpl2plus, %gpl2plus
Group: System/Libraries
Url: http://www.xfce.org
Packager: Xfce Team <xfce@packages.altlinux.org>

# Upstream: git://git.xfce.org/xfce/exo
Source: %_name-%version.tar
Patch: %_name-%version-%release.patch

BuildRequires(pre): rpm-build-licenses

BuildPreReq: rpm-build-xfce4  xfce4-dev-tools > 4.9 libxfce4util-devel libxfce4ui-devel
BuildPreReq: libICE-devel glib2-devel >= 2.27 libgtk+2-devel
BuildRequires: gtk-doc intltool perl-URI time

Requires: xfce4-common
Requires: libgtk+2-common

# There is no longer python bindings for exo.
Conflicts: python-module-exo < 0.7.0

%define _unpackaged_files_terminate_build 1

%description
Libexo is an extension library to Xfce, developed by os-cillation.
While Xfce comes with a quite few libraries that are targeted at desktop
development, libexo is targeted at application development.

%description -l ru_RU.UTF-8
Libexo - библиотека расширений Xfce предназначенная для использования в
приложениях разрабатываемых под Xfce.

%package devel
Summary: Development files for %name
Group: Development/C
PreReq: %name = %version-%release  libxfce4util-devel > 4.5

%description devel
This package contains development files required for packaging
%name-based software.

%package devel-doc
Summary: Documentation files for %name
Group: Development/Documentation
PreReq: %name-devel = %version-%release
BuildArch: noarch

%description devel-doc
This package contains documentation files required for packaging
%name-based software.

%prep
%setup -n %_name-%version
%patch -p1

# Don't use git tag in version.
%xfce4_drop_gitvtag libexo_version_tag configure.ac.in

%build
%xfce4reconf
%configure \
	--disable-static \
	--enable-maintainer-mode \
	--enable-gtk-doc \
	--enable-debug=no
%make_build

%install
%makeinstall_std
%find_lang %_name-1

%check
make check

%files -f %_name-1.lang
%doc AUTHORS NEWS TODO README
%_bindir/*
%exclude %_bindir/exo-csource
%_libdir/*.so.*
%_libdir/xfce4/*
%_datadir/xfce4/*
%config(noreplace) %_sysconfdir/xdg/xfce4/helpers.rc
%_man1dir/*
%exclude %_man1dir/exo-csource.1.*
%_desktopdir/*
%_iconsdir/hicolor/*/*/*
%_pixmapsdir/%_name-*/

# Due to conflict with altlinux-freedesktop-menu-icon-theme-default
%exclude %_iconsdir/hicolor/48x48/categories/applications-internet.png
%exclude %_iconsdir/hicolor/48x48/categories/applications-other.png

%exclude %_datadir/xfce4/helpers/debian-*.desktop

%files devel
%_bindir/exo-csource
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*
%_man1dir/exo-csource.1.*

%files devel-doc
%_datadir/gtk-doc/html/%{_name}*

%changelog
