%define oname libfltk
%define major 1.3

Name: %{oname}13
Version: %major.3
Release: alt1

Summary: Multiplatform C++ GUI Fast Light ToolKit
License: LGPL
Group: System/Libraries
URL: http://www.fltk.org/

# http://seriss.com/public/fltk/fltk/branches/branch-1.3/
Source: %name-%version.tar
Source2: fltk-%version-docs-html.tar.gz

Patch1: fltk-1.3-L3156.patch
Patch2: fltk-1.3.2-fltk_config.patch

Packager: Andrey Cherepanov <cas@altlinux.org>

BuildRequires: gcc-c++ groff-base libICE-devel libXext-devel
BuildRequires: libXft-devel libalsa-devel libjpeg-devel libGL-devel
BuildRequires: libpng-devel xprop libX11-devel fontconfig-devel
BuildPreReq: libfreetype-devel libGLU-devel libcairo-devel
BuildPreReq: libopensm-devel libXtst-devel libXcomposite-devel
BuildPreReq: libXcursor-devel libXdamage-devel libXdmcp-devel
BuildPreReq: libXfixes-devel libXi-devel libXinerama-devel
BuildPreReq: libXpm-devel libXrandr-devel libXt-devel libXv-devel
BuildPreReq: libXxf86misc-devel libXScrnSaver-devel
BuildPreReq: cmake glib2-devel libpixman-devel
BuildPreReq: pkgconfig(glproto) pkgconfig(dri2proto)
BuildPreReq: libXxf86vm-devel libharfbuzz-devel libexpat-devel

%description
The Fast Light ToolKit ("FLTK", pronounced "fulltick") is a LGPL'd
C++ graphical user interface toolkit for X (UNIX(r)), OpenGL(r),
and Microsoft(r) Windows(r) NT 4.0, 95, or 98. It was originally
developed by Mr. Bill Spitzak and is currently maintained by a
small group of developers across the world with a central
repository in the US.

%package -n %oname-devel
Summary: Development environment for multiplatform C++ GUI Fast Light ToolKit
Group: Development/C
Requires: %name = %version-%release

%description -n %oname-devel
The Fast Light ToolKit ("FLTK", pronounced "fulltick") is a LGPL'd
C++ graphical user interface toolkit for X (UNIX(r)), OpenGL(r),
and Microsoft(r) Windows(r) NT 4.0, 95, or 98. It was originally
developed by Mr. Bill Spitzak and is currently maintained by a
small group of developers across the world with a central
repository in the US.

This package includes header files, static library, GUI builder fluid,
needed to develop FLTK applications.

%package doc
Summary: Documentation and test suit for multiplatform C++ GUI Fast Light ToolKit
Group: Development/C
Provides: %oname-doc = %version-%release
BuildArch: noarch

%description doc
The Fast Light ToolKit ("FLTK", pronounced "fulltick") is a LGPL'd
C++ graphical user interface toolkit for X (UNIX(r)), OpenGL(r),
and Microsoft(r) Windows(r) NT 4.0, 95, or 98. It was originally
developed by Mr. Bill Spitzak and is currently maintained by a
small group of developers across the world with a central
repository in the US.

This package includes test suit and documentation, needed to develop
FLTK applications.

%prep
%setup
tar xf %SOURCE2
%patch1 -p0
%patch2 -p1
perl -pi -e 's/\bcat([1-3])\b/man$1/g' documentation/Makefile

# change soname from so.1.3 to so.2 .
sed -r -e 's/FL_API_VERSION=.*/FL_API_VERSION=2/' -i configure configure.in
sed -r -e 's/(libfltk[^\.]*\.so)\.1\.3/\1.2/g' -i src/Makefile

%build
%configure --disable-static --enable-shared --enable-largefile --enable-xdbe --enable-xinerama --enable-xft --enable-threads
%make_build

%install
install -d %buildroot%_docdir/fltk-%version
install -d %buildroot%_mandir

%makeinstall_std docdir=%buildroot%_docdir/fltk-%version
cp -p ANNOUNCEMENT CHANGES CREDITS README %buildroot%_docdir/fltk-%version/
cp -fR fltk-%version/documentation/html %buildroot%_docdir/fltk-%version/

%files
%_bindir/fluid
%_libdir/*.so.*
%dir %_docdir/fltk-%version
%_docdir/fltk-%version/ANNOUNCEMENT
%_docdir/fltk-%version/CREDITS
%_docdir/fltk-%version/README
%_mandir/man1/fluid.1*

%files -n %oname-devel
%_bindir/*
%exclude %_bindir/fluid
%_libdir/*.so
%_includedir/*
%_mandir/man?/*
%exclude %_mandir/man1/fluid.1*

%files doc
%_docdir/fltk-%version
%exclude %_docdir/fltk-%version/ANNOUNCEMENT
%exclude %_docdir/fltk-%version/CREDITS
%exclude %_docdir/fltk-%version/README

%changelog
