%def_disable static
%define major 1.7
%define oname fox

Name: libfox%major
Version: %major.49
Release: alt1

Summary: The FOX C++ GUI Toolkit shared libraries

License: LGPL
Group: System/Libraries
Url: http://www.fox-toolkit.org/fox.html

Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source: ftp://ftp.fox-toolkit.org/pub/%oname-%version.tar.bz2

# Automatically added by buildreq on Wed Jul 15 2009
BuildRequires: bzlib-devel gcc-c++ imake libGL-devel libICE-devel
BuildRequires: libXcursor-devel libXext-devel libXft-devel
BuildRequires: libXrandr-devel libjpeg-devel libpng-devel libtiff-devel
BuildRequires: xorg-cf-files libXfixes-devel libXi-devel

BuildPreReq: libGLU-devel libSM-devel

%description
FOX is a C++-Based Library for Graphical User Interface Development
FOX supports modern GUI features, such as Drag-and-Drop, Tooltips, Tab
Books, Tree Lists, Icons, Multiple-Document Interfaces (MDI), timers,
idle processing, automatic GUI updating, as well as OpenGL/Mesa for
3D graphics.  Subclassing of basic FOX widgets allows for easy
extension beyond the built-in widgets by application writers.

%package devel
Summary: Development files and documentation for the FOX GUI toolkit.
Group: Development/C++
Requires: %name = %version-%release

%description devel
The fox-devel package contains the files necessary to develop applications
using the FOX GUI toolkit: the header files, the reswrap resource compiler,
manual pages, and HTML documentation.

%package doc
Summary: Documentation files for the FOX GUI toolkit
Group: Development/C++
BuildArch: noarch

%description doc
The package contains HTML documentation.

%package devel-static
Summary: A version of the FOX GUI toolkit for static linking
Group: Development/C++
Requires: %name-devel = %version-%release

%description devel-static
The fox-static package contains the files necessary to link applications
to the FOX GUI toolkit statically (rather than dynamically). Statically
linked applications do not require the library to be installed on the system
running the application.

%package examples
Summary: FOX example applications
Group: Development/Other
Requires: %name = %version-%release
Provides: %oname-examples
Obsoletes: %oname-examples
Obsoletes: %{name}14-examples

%description examples
The fox-example-apps package contains executables for several FOX-based
applications, including Adie, calculator and PathFinder.

%prep
%setup -n %oname-%version
subst 's|FXFile::getExecPath(),"Adie.stx"|"%_datadir/fox-examples/","Adie.stx"|g' \
	adie/Adie.cpp

%build
%autoreconf
%add_optflags -frtti -fno-strict-aliasing
%configure  --with-opengl=opengl \
			--enable-threadsafe \
			--with-xft \
			--with-xrandr \
			--with-xim \
			--with-shape \
			--with-xshm \
			--with-xcursor \
			--with-xrender \
			--with-cups \
			--enable-release \
			%{subst_enable static}

%make_build

%install
%makeinstall

mv %buildroot%_docdir/%oname-%major %buildroot%_docdir/%name-doc-%major

# remove non-packaged files
rm -rf %buildroot%_prefix/%name
mkdir -p %buildroot/%_datadir/fox-examples
mv %buildroot/%_bindir/Adie.stx %buildroot/%_datadir/fox-examples

mv %buildroot%_bindir/calculator %buildroot%_bindir/fox-calculator

%files
%_libdir/*.so.*
%doc AUTHORS README

%files doc
%_docdir/%name-doc-%major/

%files devel
%doc ADDITIONS INSTALL TRACING
%_bindir/%oname-config
%_bindir/reswrap
%_bindir/shutterbug
%_includedir/*
%_libdir/*.so
%_man1dir/reswrap.*
%_man1dir/shutterbug.*
%_pkgconfigdir/*.pc

%if_enabled static
%files -n lib%name-devel-static
%_libdir/.a
%endif

%files examples
%_bindir/adie
%_bindir/PathFinder
%_bindir/fox-calculator
%_datadir/fox-examples
%_man1dir/adie.*
%_man1dir/PathFinder.*
%_man1dir/calculator.*

%changelog
