Name: libfreeimage
Version: 3.17.0
Release: alt1.1

Summary: Multi-format image decoder library
License: GPL and FIPL (see the license-fi.txt)
Group: System/Libraries
URL: http://freeimage.sourceforge.net/

%define srcversion %(echo %version | tr -d .)
Source: http://downloads.sourceforge.net/freeimage/FreeImage%srcversion.zip
Patch: FreeImage-3.17.0-syslibs.patch
Patch1: FreeImage-3.17.0_CVE-2015-0852.patch

BuildRequires: gcc-c++ libgomp-devel libmng-devel libpng-devel openexr-devel unzip
BuildPreReq: rpm-macros-make libraw-devel zlib-devel libwebp-devel
BuildPreReq: libtiff-devel libopenjpeg2.0-devel libjxr-devel
BuildRequires: dos2unix

%description
FreeImage is a library project for developers who would like to support
popular graphics image formats like PNG, BMP, JPEG, TIFF and others as needed by
multimedia applications. FreeImage is easy to use, fast, multithreading, safe.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%prep
%setup -n FreeImage
%patch -p1
%patch1 -p1

# remove bundled libraries
rm -r Source/Lib* Source/ZLib Source/OpenEXR
# fix line endings
find ./ -type f -print0| xargs -r0 dos2unix --
# fix Makefile
subst 's|\-o root -g root ||g' Makefile.*
# we can't built due to dependencies on private headers
# see syslibs patch
> Source/FreeImage/PluginG3.cpp
> Source/FreeImageToolkit/JPEGTransform.cpp

%build
sh ./gensrclist.sh
sh ./genfipsrclist.sh
%add_optflags %optflags_shared -fvisibility=hidden
%make_build -f Makefile.gnu
%make_build -f Makefile.fip

%install
%makeinstall_std INSTALLDIR=%buildroot%_libdir

%files
%_libdir/libfreeimage.so.*
%_libdir/libfreeimage-%version.so
%doc license-fi.txt Whatsnew.txt README.linux

%files devel
%_includedir/*
%_libdir/libfreeimage.so

%changelog
