Summary:   Library to program and control the FTDI USB serial controllers
Name:      libftdi
Version:   0.20
Release:   alt2
License:   LGPL for libftdi and GPLv2+linking exception for the C++ wrapper
Group:     System/Libraries
URL:       http://www.intra2net.com/en/developer/libftdi
Packager:  Evgeny Sinelnikov <sin@altlinux.ru>

Source:    %name-%version.tar
BuildRequires: libusb-compat-devel, pkg-config, doxygen
BuildRequires: gcc-c++ boost-devel
BuildRequires: rpm-macros-cmake
BuildRequires: cmake swig
BuildRequires: python-devel rpm-build-python

Patch:     %name-%version-%release.patch

%package   -n libftdipp
Summary:   C++ interface for libftdi library
Group:     System/Libraries

%package   devel
Summary:   Header files and libraries for libftdi
Group:     Development/C
Requires:  libftdi = %version, libusb-devel

%package   -n libftdipp-devel
Summary:   Header files and libraries for libftdipp
Group:     Development/C
Requires:  libftdi-devel = %version
Requires:  boost-devel

%package   devel-static
Summary:   Static libraries for libftdi
Group:     Development/C
Requires:  libftdi-devel = %version

%package   -n libftdipp-devel-static
Summary:   Static libraries for libftdipp
Group:     Development/C
Requires:  libftdipp-devel = %version

%package   -n python-module-ftdi
Summary:   Python bindings for libftdi
Group:     Development/Python
Requires:  libftdi = %version

%package   docs
Summary:   Documentation files for libftdi
Group:     Development/C
BuildArch: noarch

%description 
Userspace library to program and control the FTDI
USB controllers, using libusb, including the popular
bitbang mode. This library talks to next FTDI chips:
FT232BM/245BM, FT2232C/D and FT232/245R.

%description -n libftdipp
Full C++ wrapper for libftdi library

%description devel
Header files for userspace libftdi library

%description -n libftdipp-devel
Header files for full libftdi library C++ wrapper

%description devel-static
Static libraries for userspace libftdi library

%description -n libftdipp-devel-static
Static libraries for full libftdi library C++ wrapper

%description -n python-module-ftdi
Python bindings for libftdi library

%description docs
Documentation files for userspace libftdi library

%prep
%setup
%patch -p1

%build
%cmake_insource
%make_build VERBOSE=1

%install
%makeinstall_std

# Install python bindings
mkdir -p %buildroot%python_sitelibdir
mv %buildroot%_prefix/site-packages/* %buildroot%python_sitelibdir/

# Install man pages
mkdir -p %buildroot%_mandir
cp -a doc/man/* %buildroot%_mandir/

# Fix confict between libqwt-devel-5.2.0-alt7 and libftdi-docs-0.18-alt2
# for /usr/share/man/man3/deprecated.3.gz
mv %buildroot%_man3dir/deprecated.3 %buildroot%_man3dir/ftdi_deprecated.3

%files
%_libdir/libftdi.so.*

%files -n libftdipp
%_libdir/libftdipp.so.*

%files devel
%_bindir/libftdi-config
%_libdir/libftdi.so
%_libdir/pkgconfig/libftdi.pc
%_includedir/*.h

%files -n libftdipp-devel
%_libdir/libftdipp.so
%_libdir/pkgconfig/libftdipp.pc
%_includedir/*.hpp

%files devel-static
%_libdir/libftdi.a

%files -n libftdipp-devel-static
%_libdir/libftdipp.a

%files -n python-module-ftdi
%python_sitelibdir/*.py*
%python_sitelibdir/*.so

%files docs
%doc doc/html
%_man3dir/*

%changelog
