
%def_enable static
%def_disable pth
%def_enable info_nogen
%define req_gpgerror_ver 1.11
%define soversion 20

Name: libgcrypt
Version: 1.8.4
Release: alt2

%define soname %{name}%{soversion}

Group: System/Libraries
Summary: The GNU crypto library
License: LGPL
URL: http://www.gnupg.org/

Source: %name-%version.tar

Patch0: libgcrypt-1.8.4-fix-overflow-streebog.patch

# GOST patch
%define vkoversion 1.0.0
Patch1: %name-%version-vko-%vkoversion.patch

BuildRequires(pre): rpm-build-ubt
BuildRequires: libgpg-error-devel >= %req_gpgerror_ver
%if_enabled static
BuildRequires: glibc-devel-static
%endif
%if_enabled pth
BuildRequires: libpth-devel
%endif
# explicitly added texinfo for info files
BuildRequires: texinfo

%description
Libgcrypt is a general purpose cryptographic library
based on the code from GNU Privacy Guard.

%package -n %soname
Summary: The GNU crypto library
Group: System/Libraries
Requires: libgpg-error >= %req_gpgerror_ver
Provides: %name = %version-%release
# GOST provides
Provides: %name(vko) = %vkoversion
%description -n %soname
Libgcrypt is a general purpose cryptographic library
based on the code from GNU Privacy Guard.

%package -n %soname-pth
Summary: GNU Crypto library with GNU Pth user-space thread support
Group: System/Libraries
Requires: libgpg-error >= %req_gpgerror_ver
%description -n %soname-pth
This is a portion of Libgcrypt supporting user-space
threads provided by the GNU Pth library.

%package -n gcrypt-utils
Group: Networking/Other
Summary: Utilities for the %name package
Conflicts: %name-devel <= 1.4.2
Provides: %name-utils = %version-%release
Obsoletes: %name-utils < %version-%release
%description -n gcrypt-utils
This package contains %name utilities.

%package devel
Group: Development/Other
Summary: Development files for the %name package
Requires: %soname = %version-%release
Requires: libgpg-error-devel  >= %req_gpgerror_ver
%if_enabled pth
Requires: %soname-pth = %version-%release
%endif
Conflicts: %{name}0-devel
%description devel
Libgcrypt is a general purpose cryptographic library
based on the code from GNU Privacy Guard.
This package contains files needed to develop
applications using libgcrypt (e.g. Aegypten project).

%package devel-static
Summary: Static libraries for the %name-devel package
Group: Development/Other
Requires: %name-devel = %version-%release
Requires: libgpg-error-devel-static  >= %req_gpgerror_ver
Conflicts: %{name}0-devel-static
%description devel-static
Static libraries for the %name-devel package


%prep
%setup -q
%patch0 -p1
%patch1 -p1
%if_enabled info_nogen
sed -i "s|^info_TEXINFOS|#info_TEXINFOS|" doc/Makefile.am
sed -i "s|^gcrypt_TEXINFOS|#gcrypt_TEXINFOS|" doc/Makefile.am
%endif

%build
%add_optflags %optflags_shared
%autoreconf

rm -f COPYING.LIB
ln -s %_licensedir/LGPL-2.1 COPYING.LIB

%configure %{subst_enable static} \
    --enable-shared \
    --enable-noexecstack \
    --enable-ld-version-script \
    --enable-random=linux \
    --disable-dev-random

%make_build -C doc ||:
%make_build

%install
%makeinstall

# relocate shared libraries from %_libdir/ to /%_lib/.
mkdir -p %buildroot/%_lib
mv -f %buildroot%_libdir/libgcrypt.so.* %buildroot/%_lib
ln -sf ../../%_lib/libgcrypt.so.%soversion %buildroot%_libdir/libgcrypt.so

%if_enabled info_nogen
mkdir %buildroot/%_infodir/
install -m 0644 doc/*.info %buildroot/%_infodir/
%endif

%check
%ifnarch aarch64
%make check
%endif

%define _unpackaged_files_terminate_build 1

%files -n gcrypt-utils
%_bindir/dumpsexp
%_bindir/hmac256
%_bindir/mpicalc
%_man1dir/hmac256.*

%files -n %soname
/%_lib/%name.so.*
#%_libdir/%name-pthread.so.*
%doc AUTHORS ChangeLog NEWS README THANKS TODO

%if_enabled pth
%files %soname-pth
%_libdir/%name-pth.so.*
%endif

%files devel
%_bindir/*-config
%_includedir/*
%_libdir/*.so
%_datadir/aclocal/*
%_infodir/*

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%changelog
