%def_disable snapshot
%define _name gdata
%define ver_major 0.17
%define api_ver 0.0

%def_enable gnome
%def_enable goa
%def_enable vala
%def_enable gtk_doc

Name: lib%_name
Version: %ver_major.9
Release: alt0.M80P.1

Summary: Library for the GData protocol
Group: System/Libraries
License: LGPLv2+
Url: https://wiki.gnome.org/Projects/libgdata

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%define glib_ver 2.44
%define soup_ver 2.42
%define goa_ver 3.8
%define uhttpmock_ver 0.5.0

BuildRequires: autoconf-archive gtk-doc intltool
BuildRequires: glib2-devel >= %glib_ver libgdk-pixbuf-devel libgtk+3-devel liboauth-devel
BuildRequires: libjson-glib-devel libuhttpmock-devel >= %uhttpmock_ver
BuildRequires: gobject-introspection-devel libjson-glib-gir-devel libuhttpmock-gir-devel
%{?_enable_vala:BuildRequires: vala-tools}
%{?_enable_gnome:BuildRequires: gcr-libs-devel libxml2-devel libsoup-gnome-devel >= %soup_ver libsoup-gnome-gir-devel}
%{?_enable_goa:BuildRequires: libgnome-online-accounts-devel >= %goa_ver libgnome-online-accounts-gir-devel}

%description
libgdata is a GLib-based library for accessing online service APIs using the
GData protocol --- most notably, Google's services. It provides APIs to access
the common Google services, and has full asynchronous support.

%package gir
Summary: GObject introspection data for the GData library
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the GData library.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package devel-doc
Summary: Development documentation for the %name
Group: Development/Documentation
Conflicts: %name < %version-%release
BuildArch: noarch

%description devel-doc
libgdata is a GLib-based library for accessing online service APIs using the
GData protocol --- most notably, Google's services. It provides APIs to access
the common Google services, and has full asynchronous support.

This package contains development documentation for the %name.

%package gir-devel
Summary: GObject introspection devel data for the GData library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release %name-devel = %version-%release

%description gir-devel
GObject introspection devel data for the GData library.

%prep
%setup
[ ! -d m4 ] && mkdir m4

%build
%autoreconf
%configure \
	--disable-static \
	%{subst_enable gnome} \
	%{subst_enable goa} \
	--enable-introspection \
	%{?_enable_gtk_doc:--enable-gtk-doc}
%make_build

%install
%makeinstall_std

%find_lang %_name

%check
#%make check

%files -f %_name.lang
%doc NEWS README AUTHORS
%_libdir/*.so.*

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/%name.pc
%{?_enable_vala:%_vapidir/%name.*}

%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/%_name/
%endif

%files gir
%_typelibdir/GData-%api_ver.typelib

%files gir-devel
%_girdir/GData-%api_ver.gir

%changelog
