%define _name gdlmm
%define ver_major 3.7
%define api_ver 3.0
%def_disable snapshot
%def_enable doc

%if_enabled snapshot
%def_disable doc
%endif

Name: lib%{_name}3
Version: %ver_major.3
Release: alt2

Summary: C++ bindings for the gdl library
Group: System/Libraries
License: LGPLv2+
Url: http://www.gtkmm.org/

#Source: %_name-%version.tar
Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz
Patch: gdlmm-3.7.3-cxx11.patch

BuildRequires: gcc-c++ mm-common >= 0.9.8
BuildRequires: libglibmm-devel libgtkmm3-devel libgdl3-devel >= 3.7.0
BuildRequires: perl-XML-Parser
%{?_enable_snapshot:BuildRequires: xsltproc doxygen graphviz}

%description
This package contains C++ bindings for the GNOME Development/Docking
(gdl) library.

%package devel
Summary: Development files for %name
Group: Development/C++
Requires: %name = %version-%release

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %_name.

%package devel-doc
Summary: API documentation for %_name
Group: Development/C++
BuildArch: noarch
Conflicts: %name-devel < %version

%description devel-doc
This package contains the API documentation for %_name.

%prep
%setup -n %_name-%version
%patch

%build
mm-common-prepare
%autoreconf
%configure \
%{?_enable_snapshot:--enable-maintainer-mode} \
%{?_disable_doc:--disable-documentation}
%make_build

%install
%makeinstall_std

%check
%make check

%files
%_libdir/*.so.*
%doc AUTHORS NEWS README

%files devel
%_includedir/%_name-%api_ver/
%_libdir/*.so
%_libdir/%_name-%api_ver/
%_libdir/pkgconfig/*.pc

%if_enabled doc
%files devel-doc
%_docdir/%_name-%api_ver/
%_datadir/devhelp/*
%endif

%changelog
