%def_disable snapshot
%define _name gegl
%define ver_major 0.3
%define api_ver %ver_major
%def_disable docs
%def_enable gtk_doc

Name: lib%_name%api_ver
Version: %ver_major.16
Release: alt0.M80P.1

Summary: A graph based image processing framework
License: LGPLv3+/GPLv3+
Group: System/Libraries
Url: http://www.gimp.org

%if_disabled snapshot
Source: http://download.gimp.org/pub/%_name/%ver_major/%_name-%version.tar.bz2
%else
Source: %_name-%version.tar
%endif

%define babl_ver 0.1.26

BuildRequires: asciidoc gcc-c++ graphviz glib2-devel gtk-doc intltool libSDL-devel
BuildRequires: libbabl-devel >= %babl_ver  libjpeg-devel libtiff-devel libraw-devel
BuildRequires: libgomp-devel librsvg-devel libspiro-devel openexr-devel python-modules-encodings
BuildRequires: ruby w3m liblua5-devel libgtk+3-devel enscript
BuildRequires: libexiv2-devel libjasper-devel libpng-devel liblensfun-devel
BuildRequires: liblcms2-devel libwebp-devel  libv4l-devel libpoly2tri-c-devel
BuildRequires: libgexiv2-devel
BuildRequires: libjson-glib-devel gobject-introspection-devel vala-tools
# ffmpeg version of this libraries required
#BuildRequires: libavformat-devel libavcodec-devel libswscale-devel

%description
GEGL (Generic Graphics Library) is a graph based image processing framework.
GEGLs original design was made to scratch GIMPs itches for a new
compositing and processing core. This core is being designed to have
minimal dependencies. and a simple well defined API.

%package devel
Summary: Headers for developing programs that will use %name
Group: Development/C
Requires: %name = %version-%release

%description devel
This package contains the libraries and header files needed for
developing with %name.

%package gir
Summary: GObject introspection data for the GEGL
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the GEGL library.

%package gir-devel
Summary: GObject introspection devel data for the GEGL
Group: Development/Other
BuildArch: noarch
Requires: %name-devel = %version-%release
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the GEGL library.


%prep
%setup -n %_name-%version

%build
%autoreconf
%configure \
	%{subst_enable docs} \
	--disable-static \
	%{?_enable_gtk_doc:--enable-gtk-doc}
%make_build

%install
%makeinstall_std

# quick fix for gegl-sc-0.3.pc
#subst 's|gegl|gegl-%api_ver|
#       s|-lgegl-0.3-sc-0.3|-lgegl-sc-%api_ver|
#       s|gegl-0.3-0.3\/sc|gegl-%api_ver/sc|' %buildroot%_pkgconfigdir/%_name-sc-%api_ver.pc

%find_lang %_name-%api_ver

%files -f %_name-%api_ver.lang
# temporarily exclude to avoid conflict with libgegl-0.2
%exclude %_bindir/%_name
%_bindir/%_name-imgcmp
%_libdir/lib%_name-%api_ver.so.*
%_libdir/lib%_name-sc-%api_ver.so
%_libdir/lib%_name-npd-%api_ver.so
%dir %_libdir/%_name-%api_ver
%_libdir/%_name-%api_ver/*.so
%_libdir/%_name-%api_ver/grey2.json
%exclude %_libdir/%_name-%api_ver/*.la

%files devel
%_includedir/%_name-%api_ver/
%_libdir/lib%_name-%api_ver.so
%_pkgconfigdir/%_name-%api_ver.pc
%_pkgconfigdir/%_name-sc-%api_ver.pc
%_vapidir/%_name-%api_ver.deps
%_vapidir/%_name-%api_ver.vapi
%if_enabled docs
%_datadir/gtk-doc/html/%_name/
%endif

%files gir
%_typelibdir/Gegl-%api_ver.typelib

%files gir-devel
%_girdir/Gegl-%api_ver.gir

%changelog
