%def_disable snapshot
%define _libexecdir %prefix/libexec

%define ver_major 1.48
%define _name gjs
%define api_ver 1.0

%def_enable installed_tests

Name: lib%_name
Version: %ver_major.7
Release: alt0.M80P.1

Summary: Javascript Bindings for GNOME
Group: System/Libraries
# The following files contain code from Mozilla which
# is triple licensed under MPL1.1/LGPLv2+/GPLv2+:
# The console module (modules/console.c)
# Stack printer (gjs/stack.c)
License: MIT and (MPLv1.1 or GPLv2+ or LGPLv2+)
Url: https://live.gnome.org/Gjs/

%if_enabled snapshot
Source: %_name-%version.tar
%else
Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz
%endif
Source1: pkg.m4

%define glib_ver 2.50.0
%define gi_ver 1.51.2

Requires: gobject-introspection

BuildRequires: gnome-common gcc-c++ libffi-devel libmozjs38-devel libcairo-devel
BuildRequires: libmozjs38-devel libmozjs38-tools
BuildRequires: libgio-devel >= %glib_ver gobject-introspection-devel >= %gi_ver
BuildRequires: libreadline-devel libcairo-gobject-devel
BuildRequires: libgtk+3-devel libgtk+3-gir-devel

# for check
BuildRequires: /proc dbus-tools dbus-tools-gui

%description
Gjs allows using GNOME libraries from Javascript. It's based on the
Spidermonkey Javascript engine from Mozilla and the GObject introspection
framework.

%package devel
Summary: Development package for %name
Group: Development/C
Requires: %name = %version-%release
Requires: /proc

%description devel
Files for development with %name.

%package tests
Summary: Tests for the Gjs package
Group: Development/Other
Requires: %name = %version-%release
%description tests
This package provides tests programs that can be used to verify
the functionality of the installed Gjs library package.

%set_typelibdir %_libdir/%_name/girepository-1.0

%prep
%setup -n %_name-%version
[ ! -d m4 ] && mkdir m4
cp %SOURCE1 m4/

%build
export ac_cv_path_JS_INTERP=%_bindir/js
%autoreconf
%configure \
    --disable-static \
    %{?_enable_installed_tests:--enable-installed-tests}
%make_build

%install
%makeinstall_std

%check
#%%make check

%files
%_bindir/%_name
%_bindir/%_name-console
%_libdir/%name.so.*
%dir %_libdir/%_name/
%dir %_typelibdir
%_typelibdir/GjsPrivate-1.0.typelib
#%_datadir/%_name-%api_ver
%doc COPYING NEWS README

%files devel
%_includedir/%_name-%api_ver/
%_libdir/%name.so
%_pkgconfigdir/%_name-%api_ver.pc
#%_libdir/pkgconfig/%_name-internals-%api_ver.pc
%doc examples/*

%if_enabled installed_tests
%add_typelib_req_skiplist typelib(GIMarshallingTests) typelib(Regress) typelib(WarnLib)

%files tests
%_libdir/%_name/libgimarshallingtests.so
%_libdir/%_name/libregress.so
%_libdir/%_name/libwarnlib.so
%_libexecdir/%_name/installed-tests/
%_datadir/installed-tests/%_name/

%exclude %_libdir/%_name/*.la
%endif


%changelog
