%def_disable snapshot

%define rname glibmm
%define major 2.52
%define ver_base 2.52
%define api_ver 2.4

Name: libglibmm
Version: %major.1
Release: alt0.M80P.1

Summary: C++ wrapper for GLib
License: LGPL
Group: System/Libraries
Url: http://gtkmm.sourceforge.net/

%if_enabled snapshot
Source: %rname-%version.tar
%else
Source: ftp://ftp.gnome.org/pub/gnome/sources/glibmm/%major/%rname-%version.tar.xz
%endif

%define glib_ver 2.50.0
%define sigc_ver 2.9.1

%add_perl_lib_path %_libdir/glibmm-%api_ver/proc/pm

BuildRequires: gcc-c++ libgio-devel >= %glib_ver libsigc++2-devel >= %sigc_ver
BuildRequires: mm-common perl-XML-Parser doxygen xsltproc graphviz

%description
A C++ interface for glib library.

This package contains the library needed to run programs dynamically
linked with glibmm.

%package devel
Summary: Headers and development files of glibmm
Group: Development/GNOME and GTK+
Requires: %name = %version-%release

%description devel
A C++ interface for glib library.

This package contains the headers and development files that are needed,
when trying to develop or compile applications which need glibmm.

%package doc
Summary: glibmm documentation
Group: Development/Documentation
BuildArch: noarch

%description doc
Gtkmm provides a C++ interface to the GTK+ GUI library.
glibmm originally belongs to gtkmm, but is now separated,
for use with non-GUI software written in C++.

This package contains all API documentation for glibmm.


%prep
%setup -n %rname-%version

%build
mm-common-prepare --force --copy
%autoreconf
%configure \
	--disable-static \
%if_enabled snapshot
	--enable-maintainer-mode \
	--enable-documentation
%endif

%make_build

%install
%makeinstall_std

%check
# online tests restricted
#%make check

%files
%doc AUTHORS NEWS
%_libdir/*.so.*

%files devel
%_includedir/glibmm-%api_ver/
%_includedir/giomm-%api_ver/
%_libdir/*.so
%_libdir/glibmm-%api_ver/
%_libdir/giomm-%api_ver/
%_pkgconfigdir/*-%api_ver.pc

%files doc
%_docdir/%rname-%api_ver/
%_datadir/devhelp/books/%rname-%api_ver

%changelog
