%define ver_major 2.32
%def_disable static
%def_disable gtk_doc
# from gnome package
%define default_gnome_theme_name Glossy

Name: libgnome
Version: %ver_major.1
Release: alt3

Summary: GNOME base library
License: LGPLv2
Group: System/Libraries
Url: ftp://ftp.gnome.org

Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.bz2
Source1: gnome-menu.svg
Source2: gnome-button.png
Source3: desktop_gnome_peripherals_monitor.schemas

# Play system sounds by default
Patch: %name-2.22.0-alt-default_sound_settings.patch
# settings from package gnome-settings
Patch1: libgnome-alt-settings.patch
# have icons in menu and on buttons by default
Patch2: libgnome-2.28.0-alt-default-interface.patch

Patch3: libgnome-2.11.1-scoreloc.patch
# backport from upstream svn 
Patch9: libgnome-im-setting.patch
# from gnome-minimal package
Patch10: libgnome-2.22.0-alt-default_gtk_theme.patch

Patch11: libgnome-2.22.0-alt-default_browser.patch 
# https://git.gnome.org/browse/libgnome/commit/?id=ea5e602fb0b316b8e4f76a803404885c7200142c
Patch12: libgnome-2.32.1-up-warning.patch

Obsoletes: %name-utils
Provides: %name-utils = %version-%release


# From configure.in
%define GConf_ver 2.21.90
%define glib_ver 2.8.0
%define gio_ver 2.16.0
%define gnome_vfs_ver 2.5.3
%define libbonobo_ver 2.13.0
%define gtk_doc_ver 1.0
%define intltool_ver 0.40.0
%define gnome_common_ver 2.8.0
%define gnome_settings_ver 2.6.0

Requires: gnome-audio
PreReq: GConf >= %GConf_ver
Conflicts: gnome-settings

BuildPreReq: rpm-build-gnome

# From configure.in
BuildPreReq: glib2-devel >= %glib_ver
BuildPreReq: libgio-devel >= %gio_ver
BuildPreReq: gnome-vfs-devel >= %gnome_vfs_ver
BuildPreReq: libbonobo-devel >= %libbonobo_ver
BuildPreReq: libGConf-devel >= %GConf_ver
BuildPreReq: intltool >= %intltool_ver
BuildPreReq: gnome-common >= %gnome_common_ver
BuildPreReq: gtk-doc >= %gtk_doc_ver

BuildRequires: libcanberra-gtk2-devel libpopt-devel

%description
GNOME (GNU Network Object Model Environment) is a user-friendly set of
GUI applications and desktop tools to be used in conjunction with a
window manager for the X Window System. The libgnome package includes
non-GUI-related libraries that are needed to run GNOME. The libgnomeui
package contains X11-dependent GNOME library features.

%package devel
Summary: Libraries and headers for libgnome
Group: Development/GNOME and GTK+
Requires: %name = %version-%release

%description devel
GNOME (GNU Network Object Model Environment) is a user-friendly set of
GUI applications and desktop tools to be used in conjunction with a
window manager for the X Window System. The libgnome-devel package
includes the libraries and include files that you will need to
use libgnome.

You should install the libgnome-devel package if you would like to
compile GNOME applications. You do not need to install libgnome-devel
if you just want to use the GNOME desktop environment.

%package devel-doc
Summary: Development documentation for %name
Group: Development/GNOME and GTK+
Conflicts: %name < %version-%release
BuildArch: noarch

%description devel-doc
GNOME (GNU Network Object Model Environment) is a user-friendly set of
GUI applications and desktop tools to be used in conjunction with a
window manager for the X Window System. The libgnome package includes
non-GUI-related libraries that are needed to run GNOME.

This package provides development documentation for %name.

%package devel-static
Summary: Static libraries and objects for gnome libs
Group: Development/GNOME and GTK+
Requires: %name-devel = %version-%release

%description devel-static
Static libraries and objects for gnome library infrastructure

%define _gtk_docdir %_datadir/gtk-doc/html
# This is for gnome-open to land in %_bindir
%define _libexecdir %_bindir

%prep
%setup -q
%patch
%patch1 -p1
%patch2
%patch3 -p1 -b .scoreloc
%patch9 -p1 -b .im-setting
%patch10 -p1
%patch11 -p1
%patch12 -p1

subst '/DG_DISABLE_DEPRECATED/d' libgnome/Makefile.am

%build
%autoreconf
%configure \
    %{subst_enable static} \
    --disable-esd \
    --disable-schemas-install \
    %{?_enable_gtk_doc:--enable-gtk-doc} 

%make_build

%install

%make_install DESTDIR=%buildroot install

install -pD -m644 %SOURCE1 %buildroot%_datadir/pixmaps/gnome-menu.svg
install -m644 %SOURCE2 %buildroot%_datadir/pixmaps/gnome-menu.png
install -m644 %SOURCE3 %buildroot%_sysconfdir/gconf/schemas/

bzip2 -9fk ChangeLog

%find_lang --with-gnome --output=files_list %name-2.0

%define schemas desktop_gnome_accessibility_keyboard desktop_gnome_accessibility_startup desktop_gnome_applications_at_mobility desktop_gnome_applications_at_visual desktop_gnome_applications_browser desktop_gnome_applications_office desktop_gnome_applications_terminal desktop_gnome_applications_window_manager desktop_gnome_background desktop_gnome_file_views desktop_gnome_interface desktop_gnome_lockdown desktop_gnome_peripherals_keyboard desktop_gnome_peripherals_monitor desktop_gnome_peripherals_mouse desktop_gnome_sound desktop_gnome_thumbnail_cache desktop_gnome_thumbnailers desktop_gnome_typing_break

for s in %schemas; do
    echo "%%config %gconf_schemasdir/$s.schemas"
done >>files_list

%post
%gconf2_install %schemas

%preun
if [ $1 = 0 ]; then
%gconf2_uninstall %schemas
fi

%files -f files_list
%exclude %_bindir/gnome-open
%_libdir/*.so.*
%_libdir/bonobo/monikers/*.so
%bonobo_serversdir/*.server
%dir %_sysconfdir/sound
%dir %_sysconfdir/sound/events
%_datadir/pixmaps/*
%_datadir/gnome-background-properties/gnome-default.xml
%_man7dir/*
%config %_sysconfdir/sound/events/*

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*
%doc NEWS ChangeLog*

%files devel-doc
%_gtk_docdir/*

%if_enabled static
%files devel-static
%_libdir/*.a
%_libdir/bonobo/*/*.a
%endif

%exclude %_libdir/bonobo/monikers/*.la

%changelog
