%define pkgname gnomecanvasmm
%define api_version 2.6
%define major 2.26

Name: libgnomecanvasmm
Version: %major.0
Release: alt2.qa2

Summary: A C++ interface for GNOME 2 canvas library
License: LGPL
Group: System/Libraries
Url: http://gtkmm.sourceforge.net/

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: ftp://ftp.gnome.org/pub/gnome/sources/libgnomecanvasmm/%major/%name-%version.tar.bz2

BuildRequires: doxygen gcc-c++ libgnomecanvas-devel libgtkmm2-devel >= 2.8.0

%description
This package provides a C++ interface for gnomecanvas2. It is a subpackage
of the Gtk-- project.  The interface provides a convenient interface for C++
programmers to create GNOME GUIs with GTK+'s flexible object-oriented
framework.

%package devel
Summary: Headers and development files of GNOME 2 canvas library
Group: Development/GNOME and GTK+
Requires: %name = %version-%release

%description devel
This package contains the headers and various development files needed
for compiling or development of applications that wants C++ interface
of GNOME 2 canvas library.

%package doc
Summary: Documentation for %name library
Group: Development/C++
BuildArch: noarch
Conflicts: %name < %version

%description doc
This package provides API documentation for %name library.

%prep
%setup

%build
%add_optflags -std=c++11
%configure \
		--disable-maintainer-mode \
		--disable-static \
		--enable-shared

%make_build
cd docs/reference && %make

%install
%makeinstall_std

%files
%doc README
%_libdir/*.so.*

%files devel
%doc AUTHORS ChangeLog NEWS 
%_includedir/lib%pkgname-%api_version/
%_libdir/*.so
%_libdir/lib%pkgname-%api_version/
%_pkgconfigdir/*.pc

%files doc
%doc docs/reference/html

%changelog
