%define sover 6
%define sover_port 12
%def_disable static
%def_enable hal
%def_disable libhal
%define _libexecdir /usr/libexec

Name: libgphoto2
Version: 2.5.13
Release: alt0.M80P.1

Group: System/Libraries
Summary: Library to access to digital cameras
Summary (ru_RU.UTF-8): Библиотека функций для работы с цифровыми фотокамерами
Url: http://www.gphoto.org/
License: LGPLv2+
Packager: Dmitriy Khanzhin <jinn@altlinux.ru>

# Automatically added by buildreq on Mon Oct 11 2010
BuildRequires: doxygen flex gcc-c++ libexif-devel libgd2-devel libjpeg-devel liblockdev-devel libltdl7-devel libusb-compat-devel libusb-devel libxml2-devel
%if_enabled libhal
BuildRequires: libhal-devel
%endif

# IMHO, this build requires are needs when build with cdk
#BuildRequires: libncurses-devel libtinfo-devel

# Url for source code downloads now http://sourceforge.net/project/showfiles.php?group_id=8874
Source0: %name-%version.tar
Patch0:  %name-2.5.13-alt-fix-underlinked_libraries.patch

%description
This library contains all the functionality to access to modern digital
cameras via USB or the serial port.

%package -n %name-%sover
Group: System/Libraries
Summary: Library to access to digital cameras
Summary (ru_RU.UTF-8): Библиотека функций для работы с цифровыми фотокамерами
License: LGPLv2+
Provides: %name = %version-%release
Obsoletes: %name < %version-%release

%description -n %name-%sover
The %name library can be used by applications to access various digital
camera models, via standard protocols such as USB Mass Storage and PTP,
or vendor-specific protocols.
This package contains the library.

%package -n %{name}_port-%sover_port
Group: System/Libraries
Summary: Library to access to digital camera ports
Summary (ru_RU.UTF-8): Библиотека функций для работы с цифровыми фотокамерами
License: LGPLv2+

%description  -n %{name}_port-%sover_port
The %name library can be used by applications to access various digital
camera models, via standard protocols such as USB Mass Storage and PTP,
or vendor-specific protocols.
This package contains the runtime code for port access. 

%package -n %name-devel
Group: Development/C
Summary: Headers and links to compile against the %name library
Summary (ru_RU.UTF-8): Заголовочные и другие файлы для компиляции приложений с библиотекой libgphoto2
License: LGPLv2+
Requires: %name-%sover = %version-%release

%description -n %name-devel
This package contains all files which one needs to compile programs using
the %name library.

%package -n %name-devel-doc
Group: Development/Other
Summary: Development documentation of the %name library
Summary (ru_RU.UTF-8): Докумнтация для разработчиков библиотеки libgphoto2
License: LGPLv2+
BuildArch: noarch
Requires: %name-%sover = %version-%release

%description -n %name-devel-doc
This package contains development documentation of the %name library.

%if_enabled static
%package -n %name-devel-static
Group: Development/C
Summary: Static versions of %name
Summary (ru_RU.UTF-8): Статические версии библиотек libgphoto2
License: LGPLv2+
Requires: %name-devel = %version-%release

%description -n %name-devel-static
This package contains libraries which one needs to compile programs statically linked
against %name library.
%endif

##### TRANSLATED DESCRIPTIONS  #####

%description -l ru_RU.UTF-8
Библиотека предоставляет все необходимые функции для обмена данными
с современными цифровыми фотокамерами посредством USB или последовательного порта.

%description -n %name-%sover -l ru_RU.UTF-8
Библиотека libgphoto2 используется приложениями для доступа к различным моделям
цифровых камер, посредством стандартных протоколов, таких как USB-накопитель
и PTP, или специфических протоколов производителей.
Этот пакет ссодержит собственно библиотеку.

%description -n %{name}_port-%sover_port -l ru_RU.UTF-8
Библиотека libgphoto2 используется приложениями для доступа к различным моделям
цифровых камер, посредством стандартных протоколов, таких как USB-накопитель
и PTP, или специфических протоколов производителей.
Этот пакет ссодержит исполнимый код для доступа к портам.

%description -n %name-devel -l ru_RU.UTF-8
Пакет содержит все необходимые файлы для компиляции программ, использующих
библиотеку libgphoto2.

%description -n %name-devel-doc -l ru_RU.UTF-8
Пакет содержит докумнтацию для разработчиков библиотеки libgphoto2.

%if_enabled static
%description -n %name-devel-static  -l ru_RU.UTF-8
Пакет содержит статические версии библиотек для компиляции программ, использующих
библиотеку libgphoto2.
%endif

%prep
%setup -n %name-%version
%patch0 -p1

%build
sed -i '/driverdir/d' libgphoto2_port/libgphoto2_port.pc.in
%autoreconf
export udevscriptdir=/lib/udev
export utilsdir=%_libexecdir/%name
%configure \
    %{subst_enable static} \
    --with-drivers=all \
%if_disabled libhal
    --without-hal \
%endif
    --disable-rpath
%make_build

%install
%makeinstall_std

# create udev support
/bin/mkdir -p %buildroot/lib/udev/rules.d
/bin/touch %buildroot/lib/udev/rules.d/40-%name.rules
/bin/mkdir -p %buildroot/lib/udev/hwdb.d
/bin/touch %buildroot/lib/udev/hwdb.d/40-%name.hwdb

%if_enabled hal
# create hal support
/bin/mkdir -p %buildroot%_datadir/hal/fdi/information/20thirdparty
/bin/touch %buildroot%_datadir/hal/fdi/information/20thirdparty/10-camera-libgphoto2.fdi
%endif

# correct content of doc. directory
/bin/rm -rf %buildroot/%_datadir/doc/%name/{linux-hotplug,ABOUT-NLS,COPYING,ChangeLog}

# remove circular symlink in /usr/include/gphoto2
/bin/rm -f %buildroot%_includedir/gphoto2/gphoto2
# udev helper not used now
/bin/rm -f %buildroot/lib/udev/check-ptp-camera
# remove .la files
/bin/rm -f %buildroot%_libdir/%name/*/*.la
/bin/rm -f %buildroot%_libdir/%{name}_port/*/*.la

%find_lang --output=%name.lang %name-%sover
%find_lang --append --output=%name.lang %{name}_port-%sover_port

##### PRE/POST INSTALL SCRIPTS #####

%pre -n %name-%sover
# create group
/usr/sbin/groupadd -fr camera || :

%post -n %name-%sover
# create udev rules
%_libexecdir/%name/print-camera-list --verbose udev-rules version 201 owner root mode 0660 group camera > /lib/udev/rules.d/40-%name.rules 2> /dev/null
%_libexecdir/%name/print-camera-list hwdb > /lib/udev/hwdb.d/40-%name.hwdb 2> /dev/null
%if_enabled hal
# create .fdi file
%_libexecdir/%name/print-camera-list hal-fdi > %_datadir/hal/fdi/information/20thirdparty/10-camera-libgphoto2.fdi
%endif

%triggerpostun -- %name <= 2.4.0
/sbin/ldconfig


##### FILE LISTS FOR ALL BINARY PACKAGES #####

%files -n %name-%sover -f %name.lang
%_libdir/%name.so.*
%dir %_libdir/%name
%dir %_libdir/%name/*
%_libdir/%name/*/*.so
%dir %_libexecdir/%name
%_libexecdir/%name/print-camera-list
%ghost /lib/udev/hwdb.d/*
%ghost /lib/udev/rules.d/*
%dir %_datadir/%name
%_datadir/%name/*
%dir %_datadir/doc/%name
%_datadir/doc/%name/AUTHORS
%_datadir/doc/%name/NEWS
%_datadir/doc/%name/README
%exclude %_datadir/locale/*/LC_MESSAGES/%{name}_port*
%if_enabled hal
%ghost %_datadir/hal/fdi/information/20thirdparty/*
%endif

%files -n %{name}_port-%sover_port -f %name.lang
%_libdir/%{name}_port.so.*
%dir %_libdir/%{name}_port
%dir %_libdir/%{name}_port/*
%_libdir/%{name}_port/*/*.so
%dir %_datadir/%{name}_port
%_datadir/%{name}_port/*
%dir %_datadir/doc/%{name}_port
%_datadir/doc/%{name}_port/*
%exclude %_datadir/locale/*/LC_MESSAGES/%{name}*

%files -n %name-devel
%_bindir/*-config
%_includedir/gphoto2
%_libdir/*.so
%_libdir/pkgconfig/*
%_man3dir/%{name}*

%files -n %name-devel-doc
%_datadir/doc/%name/*
%exclude %_datadir/doc/%name/AUTHORS
%exclude %_datadir/doc/%name/NEWS
%exclude %_datadir/doc/%name/README

%if_enabled static
%files -n %name-devel-static
%_libdir/*.a
%_libdir/%name/*/*.a
%_libdir/%{name}_port/*/*.a
%endif

%changelog
