%define MOUNT_DIR /media

Name: libgpod4
Version: 0.8.3
Release: alt5

Summary: iPod access library
Group: Sound
License: %lgpl3plus
URL: http://www.gtkpod.org/libgpod

Source: %name-%version.tar
Patch: %name-%version-%release.patch
Patch1: %name-0.8.3-alt-swig.patch

Provides: libgpod = %version-%release
Obsoletes: libgpod < 0.7

BuildRequires: gcc-c++ gtk-doc intltool
BuildRequires: glib2-devel libgio-devel libsqlite3-devel libplist-devel
BuildRequires: libsgutils-devel libusb-devel zlib-devel libimobiledevice-devel
BuildRequires: libtag-devel libxml2-devel libgdk-pixbuf-devel
BuildRequires: python-module-pygobject-devel python-module-mutagen swig
BuildRequires: rpm-build-licenses
BuildRequires: /proc mono-devel libgtk-sharp2-devel

%description
libgpod is a library meant to abstract access to an iPod content. It
provides an easy to use API to retrieve the list of files and playlist
stored on an iPod, to modify them and to save them back to the iPod.

%package -n libgpod-devel
Summary: Development files for libgpod
Group: Development/C
Requires: %name = %version-%release

%description -n libgpod-devel
Files needed to develop applications that use libgpod,
an iPod access library.

%package -n libgpod-devel-doc
Summary: Development documentation for libgpod
Group: Development/C
BuildArch: noarch

%description -n libgpod-devel-doc
API documentation in gtk-doc format for libgpod,
an iPod access library.

%package -n python-module-gpod
Summary: Python bindings for libgpod
Group: Development/Python
Requires: %name = %version-%release
Obsoletes: python-modules-gpod < %version-%release
Provides: python-modules-gpod = %version-%release

%description -n python-module-gpod
Python bindings for libgpod, an iPod access library.

%package -n libgpod-sharp
Summary: C#/.NET library to access iPod content
Group: Development/Other
Requires: %name = %version-%release

%description -n libgpod-sharp
C#/.NET library to access iPod content.  Provides bindings to the libgpod
library.


%package -n libgpod-sharp-devel
Summary: Development files for libgpod-sharp
Group: Development/Other
Requires: libgpod-sharp = %version-%release

%description -n libgpod-sharp-devel
C#/.NET library to access iPod content.  Provides bindings to the libgpod
library.

This package contains the files required to develop programs that will use
libgpod-sharp.

%prep
%setup
%patch -p1
%patch1

# remove execute perms on the python examples as they'll be installed in %%doc
chmod -x bindings/python/examples/*.py

%build
%autoreconf
%configure \
	--disable-static \
	--enable-gtk-doc \
	--enable-pygobject \
	--without-hal \
	--enable-udev \
	--with-libimobiledevice \
	--with-temp_mount_dir="%MOUNT_DIR" \
	--enable-more-warnings=no

%make_build
pushd bindings/python
make README
popd

%install
%makeinstall_std

# remove Makefiles from the python examples dir
rm -rf bindings/python/examples/Makefile*

rm -f %buildroot%python_sitelibdir/gpod/*.la

%find_lang libgpod

%files -f libgpod.lang
%_bindir/*
%_libdir/*.so.*
/lib/udev/rules.d/*
/lib/udev/*-set-info

%files -n libgpod-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/libgpod-1.0.pc

%files -n libgpod-devel-doc
%_datadir/gtk-doc/html/*

%files -n python-module-gpod
%doc COPYING bindings/python/README bindings/python/examples
%python_sitelibdir/gpod

%files -n libgpod-sharp
%_libdir/libgpod

%files -n libgpod-sharp-devel
%_pkgconfigdir/libgpod-sharp.pc

%changelog
