%define _name granite
%define ver_major 0.3
%define api_ver 1.0

Name: libgranite
Version: %ver_major.1
Release: alt1

Summary: Extension of GTK+3 libraries
Group: System/Libraries
License: GPLv3+
Url: https://launchpad.net/granite

Source: https://launchpad.net/%_name/%ver_major/%version/+download/%_name-%version.tar.xz

Packager: Igor Zubkov <icesik@altlinux.org>

BuildRequires: cmake rpm-build-gir vala libgtk+3-devel libgee0.8-devel
BuildRequires: libpixman-devel gobject-introspection-devel libXdmcp-devel
BuildRequires: libXdamage-devel libXxf86vm-devel libharfbuzz-devel libpng-devel
BuildRequires: libXinerama-devel libXi-devel libXrandr-devel libXcursor-devel
BuildRequires: libXcomposite-devel libxkbcommon-devel libwayland-cursor-devel
BuildRequires: at-spi2-atk-devel libgtk+3-gir-devel libgee0.8-gir-devel
BuildRequires: libexpat-devel

%description
Granite is an extension of GTK+. Among other things, it provides the
commonly-used widgets such as modeswitchers, welcome screens, AppMenus,
search bars, and more found in elementary apps.

This package contains the shared library.

%package devel
Summary: Extension of GTK+ libraries (development files)
Group: Development/GNOME and GTK+

Requires: %name = %version-%release

%description devel
Granite is an extension of GTK+. Among other things, it provides the
commonly-used widgets such as modeswitchers, welcome screens, AppMenus,
search bars, and more found in elementary apps.

This package contains header files.

%package vala
Summary: Vala language bindings for the granite library
Group: Development/Other
BuildArch: noarch
Requires: %name = %version-%release

%description vala
This package provides Vala language bindings for the granite library.

%package -n granite-demo
Summary: Extension of GTK+ libraries (demo binary)
Group: Development/GNOME and GTK+

Requires: %name = %version-%release

%description -n granite-demo
Granite is an extension of GTK+. Among other things, it provides the
commonly-used widgets such as modeswitchers, welcome screens, AppMenus,
search bars, and more found in elementary apps.

This package contains a small demo application to show Granite Widgets.

%package gir
Summary: GObject introspection data for the granite library
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the granite library.

%package gir-devel
Summary: GObject introspection devel data for the granite library.
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the granite library.

%prep
%setup -n %_name-%version

%build
%cmake_insource
%make_build VERBOSE=1

%install
%makeinstall_std

%find_lang %_name

%files -f %_name.lang
%doc AUTHORS INSTALL README
%_libdir/*.so.*

%files devel
%_libdir/*.so
%dir %_includedir/%_name
%_includedir/%_name/*.h
%_pkgconfigdir/%_name.pc

%files -n %_name-demo
%_bindir/*
%_desktopdir/%_name-demo.desktop
%_datadir/icons/hicolor/*/*/*.svg

%files gir
%_typelibdir/Granite-%api_ver.typelib

%files gir-devel
%_girdir/Granite-%api_ver.gir

%files vala
%_datadir/vala/vapi/%_name.deps
%_datadir/vala/vapi/%_name.vapi

%changelog
