%define ver_major 1.14
%def_disable static
%def_enable gtk_doc
%def_enable introspection

Name: libgsf
Version: %ver_major.41
Release: alt0.M80P.1

Summary: GNOME Structured file library
License: %lgpl2plus
Group: System/Libraries
Url: http://www.gnumeric.org/

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz

BuildPreReq: rpm-build-gnome rpm-build-licenses

# From configure.ac
BuildPreReq: intltool gtk-doc >= 1.0
BuildPreReq: libgio-devel >= 2.26.0
BuildPreReq: libxml2-devel >= 2.4.16
BuildRequires: libgdk-pixbuf-devel bzlib-devel zlib-devel
%{?_enable_introspection:BuildRequires: gobject-introspection-devel}
%{?_enable_static:BuildRequires: glibc-devel-static}
# for check
BuildRequires: unzip

%description
GNOME Structured file library

%package devel
Summary: Libraries and include files for gsf
Group: Development/C
Requires: %name = %version-%release

%description devel
This package provides the necessary development libraries and include
files to allow you to develop programs using gsf.

%package gir
Summary: GObject introspection data for the gsf library
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the GNOME Structured file library.

%package gir-devel
Summary: GObject introspection devel data for the gsf library
Group: Development/Other
BuildArch: noarch
Requires: %name-gir = %version-%release
Requires: %name-devel = %version-%release

%description gir-devel
GObject introspection devel data for the GNOME Structured file library.


%package devel-doc
Summary: Development documentation for gsf
Group: Development/C
BuildArch: noarch
Conflicts: %name-gnome < %version

%description devel-doc
This package contains the documentation for development programs using gsf.

%package devel-static
Summary: Static gsf libraries
Group: Development/C
Requires: %name-devel = %version-%release

%description devel-static
This package provides the necessary development libraries to allow you
to build programs staticallly linked against libgsf.

%setup_python_module gsf
%package -n python-module-gsf
Summary: Python bindings for %name
Group: Development/Python
Autoreq: yes
Requires: %name = %version-%release
%add_python_req_skip _gsf

%description -n python-module-gsf
This package contains files that are needed to use libgsf from Python
programs.

%define _gtk_docdir %_datadir/gtk-doc/html

%prep
%setup -q

subst 's/pythondir/pyexecdir/' python/Makefile.am

%build
%autoreconf
%configure \
    --with-gdk-pixbuf \
    --with-bz2 \
    %{?_enable_gtk_doc:--enable-gtk-doc} \
    %{?_enable_introspection:--enable-introspection=yes} \
    %{subst_enable static}

%make_build

%install
%makeinstall_std

%find_lang --with-gnome %name

%check
%make check

%files -f %name.lang
%_bindir/*
%_libdir/%name-1.so.*
%_datadir/thumbnailers/gsf-office.thumbnailer
%_man1dir/*
%doc AUTHORS README TODO NEWS

%files devel
%dir %_includedir/%name-1
%dir %_includedir/%name-1/gsf
%_includedir/%name-1/gsf/*.h
%_libdir/%name-1.so
%_pkgconfigdir/%name-1.pc

%if_enabled introspection
%files gir
%_typelibdir/Gsf-1.typelib

%files gir-devel
%_girdir/Gsf-1.gir
%endif

%if_enabled static
%files devel-static
%_libdir/%name-1.a
%endif

%files devel-doc
%_gtk_docdir/*


%changelog
