%define _name gssdp
%define ver_major 1.0

%def_disable static
%def_enable gtk_doc
%def_enable introspection

Name: lib%_name
Version: %ver_major.2
Release: alt0.M80P.1

Summary: Resource discovery and announcement over SSDP
Group: System/Libraries
License: LGPLv2+
Url: http://www.gupnp.org/

Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz

BuildRequires: gnome-common gtk-doc libsoup-devel >= 2.26.1 libgio-devel >= 2.32
BuildRequires: vala-tools rpm-build-vala libvala-devel
%{?_enable_introspection:BuildPreReq: gobject-introspection-devel libsoup-gir-devel}

%description
GSSDP implements resource discovery and announcement over SSDP and is part
of gUPnP.

%package devel
Summary: Development files for gSSDP library
Group: Development/C
Requires: %name = %version-%release

%description devel
This package provides files for development with gSSDP.

%package devel-doc
Summary: Development documentation for gSSDP
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
gSSDP implements resource discovery and announcement over SSDP and is part
of gUPnP.

This package provides development documentation for gSSDP.

%package gir
Summary: GObject introspection data for the  library
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the  library

%package gir-devel
Summary: GObject introspection devel data for the  library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the GSSDP library

%prep
%setup -n %_name-%version

[ ! -d m4 ] && mkdir m4

%build
%autoreconf
%configure  --disable-static \
	    --without-gtk \
	    %{?_enable_gtk_doc:--enable-gtk-doc} \
	    %{subst_enable introspection}

%make_build

%install
%makeinstall_std

%files
%_libdir/*.so.*
%doc AUTHORS README NEWS ChangeLog

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc
%_vapidir/*.deps
%_vapidir/*.vapi

%files devel-doc
%_datadir/gtk-doc/html/*

%if_enabled introspection
%files gir
%_typelibdir/*.typelib

%files gir-devel
%_girdir/*.gir
%endif


%changelog
