%define realname gtk-sharp
%def_disable doc

Summary: GTK+ and GNOME bindings for Mono
Name: lib%{realname}2
Version: 2.12.11
Release: alt5%ubt
License: LGPLv2+
Group: Development/Other
Url: http://www.mono-project.com/
Source: http://ftp.gnome.org/pub/GNOME/sources/%realname/2.12/%name-%version.tar

Patch0: %name-%version-alt-build.patch
Patch1: %name-2.12.11-alt-glib2.patch

Requires: libglade libgtk+2 >= 2.12.0

BuildRequires(pre): rpm-build-ubt
BuildPreReq: glib2-devel >= 2.12.0
BuildPreReq: libpango-devel
BuildPreReq: libatk-devel
BuildPreReq: libgtk+2-devel >= 2.12.0
BuildPreReq: libglade-devel >= 2.3.6
BuildPreReq: rpm-build-mono perl-XML-LibXML

BuildRequires: gcc-c++ mono-devel 
%{?_enable_doc:BuildRequires: mono-monodoc-devel}
BuildRequires: /proc

Conflicts: lib%{realname}2-mono4
Obsoletes: lib%{realname}2-mono4
Provides: lib%{realname}2-mono4 = %version-%release

%description
This package provides a library that allows you to build
fully native graphical GNOME applications using Mono. Gtk#
is a binding to GTK+, the cross platform user interface
toolkit used in GNOME. It includes bindings for Gtk, Atk,
Pango, Gdk, libgnome, libgnomeui and libgnomecanvas. Gtk#
2.10.x binds GTK+ 2.10.

%package gapi
Summary: Glib and GObject C source parser and C generator for the creation and maintenance of managed bindings for Mono and .NET
Group: Development/Other
Requires: %name = %version-%release
Provides: lib%{realname}2-mono4-gapi = %version-%release
Conflicts: lib%{realname}2-mono4-gapi
Obsoletes: lib%{realname}2-mono4-gapi

%description gapi
This package provides developer tools for the creation and
maintainance of managed bindings to native libraries which utilize
glib and GObject. Some examples of libraries currently bound using
the GAPI tools and found in Gtk# include Gtk, Atk, Pango, Gdk,
libgnome, libgnomeui and libgnomecanvas.

%package devel
Summary: .Net language bindings for Gtk+ and GNOME development files
Group: Development/Other
Requires: %name-gapi = %version-%release
Provides: lib%{realname}2-mono4-devel = %version-%release
Conflicts: lib%{realname}2-mono4-devel
Obsoletes: lib%{realname}2-mono4-devel

%description devel
This package includes development files for the Gtk\# project
to parse and bind GObject libraries.

%package doc
Summary: %name documentation in monodoc format
Group: Documentation
Provides: %name-monodoc = %version-%release
Obsoletes: %name-monodoc
Provides: %name-mono4-monodoc = %version-%release
Obsoletes: %name-mono4-monodoc
Requires: mono-monodoc >= 2.2
BuildArch: noarch
Obsoletes: lib%{realname}2-mono4-doc
Provides: lib%{realname}2-mono4-doc = %version-%release
Conflicts: lib%{realname}2-mono4-doc

%description doc
This package includes documentation in monodoc format for the Gtk\# project
for use with monodoc / monodoc Gtk# (from mono-tools) / monodevelop.

%prep
%setup -q

%patch0 -p1
%patch1 -p0

%build
NOCONFIGURE=1 ./bootstrap-2.12
%configure --disable-static
%make

%install
%make_install DESTDIR=%buildroot install

%files
%doc README COPYING ChangeLog
%prefix/lib/gtk-sharp-2.0
%exclude %prefix/lib/gtk-sharp-2.0/gapi*
%_monodir/gac/*
%_monodir/gtk-sharp-2.0
%_libdir/*.so
%_pkgconfigdir/*
%exclude %_pkgconfigdir/gapi-2.0.pc

%files gapi
%_bindir/gapi2*
%prefix/lib/gtk-sharp-2.0/gapi*
%dir %_datadir/gapi-2.0

%files devel
%_datadir/gapi-2.0/*.xml
%_pkgconfigdir/gapi-2.0.pc

%if_enabled doc
%files doc
%_monodocdir/*
%endif

%changelog
